/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ProcessDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jooq.tools.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeleteDocumentViewFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(DeleteDocumentViewFormatter.class);
    private final String documentViewIdKey = "documentViewId";
    private final String processDefIdKey = "procDefId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String documentViewId = map.get("documentViewId");
            String processDefId = map.get("procDefId");
            String processDef = this.getProcessNameValue(processDefId);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), processDef);
            formattedMap.put(AuditParamsNames.DOCUMENT_VIEW_ID.toString(), documentViewId);
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getProcessNameValue(String processDefId) {
        if (StringUtils.isBlank((String)processDefId) || processDefId.equals("null")) {
            Locale locale = LocaleContextHolder.getLocale();
            return MessageHelper.getMessage((String)"Kazdy", (Locale)locale, (Object[])new Object[0]);
        }
        return new ProcessDef(processDefId).getProcessName();
    }
}

