/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceImportFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DataSourceImportFormatter.class);
    private final String importedKey = "imported";
    private final String overwrittenKey = "overwritten";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String imported = map.get("imported");
            String overwritten = map.get("overwritten");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)imported)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_IMPORTED.name(), imported);
            }
            if (StringUtils.isNotBlank((CharSequence)overwritten)) {
                formattedMap.put(AuditParamsNames.DATASOURCE_OVERWRITTEN.name(), overwritten);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

