/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.configuration.dto.translations.TranslationType;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportTranslationsFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ImportTranslationsFormatter.class);
    private final String fileFormatKey = "fileFormat";
    private final String translationTypeKey = "translationType";
    private final String addedCountKey = "addedCount";
    private final String modifiedCountKey = "modifiedCount";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String fileFormat = map.get("fileFormat");
            TranslationType translationType = TranslationType.valueOf((String)map.get("translationType"));
            int addedCount = map.get("addedCount") != null ? Integer.parseInt(map.get("addedCount")) : 0;
            int modifiedCount = map.get("modifiedCount") != null ? Integer.parseInt(map.get("modifiedCount")) : 0;
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.FILE_FORMAT.name(), fileFormat);
            formattedMap.put(AuditParamsNames.TRANSLATION_TYPE.name(), MessageHelper.getMessage((String)translationType.getTranslationKey()));
            formattedMap.put(AuditParamsNames.ADDED_TRANSLATIONS_COUNT.name(), String.valueOf(addedCount));
            formattedMap.put(AuditParamsNames.MODIFIED_TRANSLATIONS_COUNT.name(), String.valueOf(modifiedCount));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

