/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ActivityStateChangeFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(ActivityStateChangeFormatter.class);
    private final String processIdKey = "ProcessId";
    private final String activityIdKey = "ActivityId";
    private static String isGroupOperationKey = "is_group_operation";
    private static String operationSourceKey = "operation_source";
    private static String packageNameKey = "package_name";
    private static String amountKey = "amount";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String amount;
            String isGroupOperation;
            String operationSource;
            String packageName;
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            String processId = map.get("ProcessId");
            String activityId = map.get("ActivityId");
            if (StringUtils.isNotEmpty((CharSequence)processId) && StringUtils.isNotEmpty((CharSequence)activityId)) {
                ActivityDef activityDef = new ActivityDef(processId, activityId);
                formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessName());
                formattedMap.put(AuditParamsNames.PROCESS_ID.toString(), activityDef.getProcessId());
                formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
                formattedMap.put(AuditParamsNames.ACTIVITY_ID.toString(), activityDef.getActivityId());
            }
            if ((packageName = map.get(packageNameKey)) != null) {
                formattedMap.put(AuditParamsNames.PACKAGE_NAME.name(), packageName);
            }
            if ((operationSource = map.get(operationSourceKey)) != null) {
                if (operationSource.isEmpty()) {
                    formattedMap.put(AuditParamsNames.OPERATION_SOURCE.name(), MessageHelper.getMessage((String)"Wyszukiwanie"));
                } else if (operationSource.equals("administracja_pakiety")) {
                    formattedMap.put(AuditParamsNames.OPERATION_SOURCE.name(), MessageHelper.getMessage((String)operationSource));
                } else {
                    formattedMap.put(AuditParamsNames.OPERATION_SOURCE.name(), MessageHelper.getMessage((String)"Widok") + " " + operationSource);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)(isGroupOperation = map.get(isGroupOperationKey)))) {
                formattedMap.put(AuditParamsNames.IS_GROUP_OPERATION.name(), MessageHelper.getMessage((String)isGroupOperation));
            }
            if (StringUtils.isNotBlank((CharSequence)(amount = map.get(amountKey)))) {
                formattedMap.put(AuditParamsNames.AMOUNT.name(), amount);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

