/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.calendar.resource.CalendarResourceTranslationService;
import com.suncode.pwfl.calendar.user.DeleteUserEventResult;
import com.suncode.pwfl.calendar.user.api.UserCalendarService;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class UserCalendarEventFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UserCalendarEventFormatter.class);
    private final String idKey = "id";
    private final String calendarKey = "calendar";
    private final String titleKey = "title";
    private final String descriptionKey = "description";
    private final String allDayKey = "allDay";
    private final String startDateTimeUTCKey = "startDateTimeUTC";
    private final String endDateTimeUTCKey = "endDateTimeUTC";
    private final String recurrentKey = "recurrent";
    private final String durationMinutesKey = "durationMinutes";
    private final String recurrencePatternKey = "recurrencePattern";
    private final String participantsKey = "participants";
    private final String resourcesKey = "resources";
    private final String timeZoneKey = "timeZone";
    private final String deleteStatusKey = "deleteStatus";
    private final String modifyTypeKey = "modifyType";
    private final String modifyRecurrenceStartDateTimeKey = "modifyRecurrenceStartDateTime";
    private final String modifyRecurrenceEndDateTimeKey = "modifyRecurrenceEndDateTime";
    private final String modifyRecurrenceAllDayKey = "modifyRecurrenceAllDay";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String calendar = map.get("calendar");
            String title = map.get("title");
            String description = map.get("description");
            String allDay = map.get("allDay");
            String startDateTimeUTC = map.get("startDateTimeUTC");
            String endDateTimeUTC = map.get("endDateTimeUTC");
            String recurrent = map.get("recurrent");
            String durationMinutes = map.get("durationMinutes");
            String recurrencePattern = map.get("recurrencePattern");
            String participants = map.get("participants");
            String resources = map.get("resources");
            String timeZone = map.get("timeZone");
            String deleteStatus = map.get("deleteStatus");
            String modifyType = map.get("modifyType");
            String modifyRecurrenceStartDateTime = map.get("modifyRecurrenceStartDateTime");
            String modifyRecurrenceEndDateTime = map.get("modifyRecurrenceEndDateTime");
            String modifyRecurrenceAllDay = map.get("modifyRecurrenceAllDay");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)calendar)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_CALENDAR.name(), this.formatTextValueChange(calendar, this::translateCalendar));
            } else {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_CALENDAR.name(), MessageHelper.getMessage((String)"Moj_kalendarz"));
            }
            if (StringUtils.isNotBlank((CharSequence)title)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_TITLE.name(), this.formatTextValueChange(title));
            }
            if (StringUtils.isNotBlank((CharSequence)description)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_DESCRIPTION.name(), this.formatTextValueChange(description));
            }
            if (StringUtils.isNotBlank((CharSequence)allDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_ALL_DAY.name(), this.translateBooleanValue(allDay, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)startDateTimeUTC)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_START_DATE_TIME_UTC.name(), this.formatDate(startDateTimeUTC, allDay, timeZone));
            }
            if (StringUtils.isNotBlank((CharSequence)endDateTimeUTC)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_END_DATE_TIME_UTC.name(), this.formatDate(endDateTimeUTC, allDay, timeZone));
            }
            if (StringUtils.isNotBlank((CharSequence)recurrent)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_RECURRENT.name(), this.translateBooleanValue(recurrent, LocaleContextHolder.getLocale()));
            }
            if (StringUtils.isNotBlank((CharSequence)durationMinutes)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_DURATION_MINUTES.name(), this.formatTextValueChange(durationMinutes));
            }
            if (StringUtils.isNotBlank((CharSequence)recurrencePattern)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_RECURRENCE_PATTERN.name(), this.formatTextValueChange(recurrencePattern, "\n"));
            }
            if (StringUtils.isNotBlank((CharSequence)participants)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_PARTICIPANTS.name(), this.formatTextValueChange(participants));
            }
            if (StringUtils.isNotBlank((CharSequence)resources)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_RESOURCES.name(), this.formatTextValueChange(resources, this::translateResources));
            }
            if (StringUtils.isNotBlank((CharSequence)timeZone)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_TIMEZONE.name(), this.formatTextValueChange(timeZone));
            }
            if (StringUtils.isNotBlank((CharSequence)deleteStatus)) {
                formattedMap.put(AuditParamsNames.CALENDAR_EVENT_DELETE_STATUS.name(), this.formatTextValueChange(deleteStatus, this::getDeleteStatusTranslation));
            }
            if (StringUtils.isNotBlank((CharSequence)modifyType)) {
                formattedMap.put(AuditParamsNames.CALENDAR_MODIFY_RECURRENCE_TYPE.name(), this.formatTextValueChange(modifyType));
            }
            if (StringUtils.isNotBlank((CharSequence)modifyRecurrenceStartDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_MODIFY_RECURRENCE_START_DATE_TIME.name(), this.formatTextValueChange(modifyRecurrenceStartDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)modifyRecurrenceEndDateTime)) {
                formattedMap.put(AuditParamsNames.CALENDAR_MODIFY_RECURRENCE_END_DATE_TIME.name(), this.formatTextValueChange(modifyRecurrenceEndDateTime));
            }
            if (StringUtils.isNotBlank((CharSequence)modifyRecurrenceAllDay)) {
                formattedMap.put(AuditParamsNames.CALENDAR_MODIFY_RECURRENCE_ALL_DAY.name(), this.translateBooleanValue(modifyRecurrenceAllDay, LocaleContextHolder.getLocale()));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getDeleteStatusTranslation(String deleteStatus) {
        try {
            DeleteUserEventResult status = DeleteUserEventResult.valueOf((String)deleteStatus);
            String translationKey = this.getDeleteStatusTranslationKey(status);
            return MessageHelper.getMessage((String)translationKey);
        }
        catch (Exception e) {
            return deleteStatus;
        }
    }

    private String getDeleteStatusTranslationKey(DeleteUserEventResult status) {
        return switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case DeleteUserEventResult.DELETED -> "Usuniete";
            case DeleteUserEventResult.CANCELLED -> "Anulowane";
        };
    }

    private String translateResources(String resourcesString) {
        return Stream.of(resourcesString.split(",")).map(this::translateResource).collect(Collectors.joining(", "));
    }

    private String translateResource(String resourceString) {
        try {
            List<String> resourceValues = List.of(resourceString.split(":"));
            Long resourceId = Long.valueOf(resourceValues.get(0));
            CalendarResourceTranslationService calendarResourceTranslationService = (CalendarResourceTranslationService)SpringContext.getBean(CalendarResourceTranslationService.class);
            String translatedName = calendarResourceTranslationService.getCalendarResourceTranslation(resourceId, TranslatedFieldType.NAME);
            if (StringUtils.isNotBlank((CharSequence)translatedName)) {
                return translatedName;
            }
            if (resourceValues.size() > 1) {
                return resourceValues.get(1);
            }
            return resourceValues.get(0);
        }
        catch (Exception ignored) {
            return resourceString;
        }
    }

    private String translateCalendar(String calendarString) {
        try {
            if (StringUtils.isBlank((CharSequence)calendarString)) {
                return MessageHelper.getMessage((String)"Moj_kalendarz");
            }
            List<String> calendarValues = List.of(calendarString.split(":", -1));
            Long calendarId = Long.valueOf(calendarValues.get(0));
            UserCalendarService userCalendarService = (UserCalendarService)SpringContext.getBean(UserCalendarService.class);
            String translatedName = userCalendarService.getCalendarTranslation(calendarId, TranslatedFieldType.NAME);
            if (StringUtils.isNotBlank((CharSequence)translatedName)) {
                return translatedName;
            }
            if (calendarValues.size() > 1) {
                return calendarValues.get(1);
            }
            return calendarValues.get(0);
        }
        catch (Exception ignored) {
            return calendarString;
        }
    }

    private String formatDate(String date, String allDay, String timeZoneId) {
        try {
            if (StringUtils.isBlank((CharSequence)date)) {
                return date;
            }
            String[] dateValues = date.split(";", -1);
            if (dateValues.length < 2) {
                return this.formatDate(date, Boolean.parseBoolean(allDay), timeZoneId);
            }
            String[] allDayValues = allDay.split(";", -1);
            String[] timeZoneIdValues = timeZoneId.split(";", -1);
            String oldDate = this.formatDate(dateValues[0], Boolean.parseBoolean(allDayValues[0]), timeZoneIdValues[0]);
            String newDate = this.formatDate(dateValues[1], Boolean.parseBoolean(allDayValues[1]), timeZoneIdValues[1]);
            return String.format("%s > %s", oldDate, newDate);
        }
        catch (Exception e) {
            return date;
        }
    }

    private String formatDate(String date, boolean allDay, String timeZoneId) {
        try {
            LocalDateTime localDateTime = LocalDateTime.parse(date);
            if (allDay) {
                DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                return localDateTime.format(dateFormatter);
            }
            TimeZone timeZone = TimeZone.getTimeZone(timeZoneId);
            OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.UTC).withOffsetSameInstant(timeZone.toZoneId().getRules().getOffset(localDateTime));
            return offsetDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mmZZZZZ"));
        }
        catch (Exception e) {
            return date;
        }
    }
}

