/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpdateEmailConfigurationFormatter
extends Formatter {
    private final String idKey = "EMAIL_CONFIGURATION_ID";
    private final String nameKey = "EMAIL_CONFIGURATION_NAME";
    private final String emailKey = "EMAIL_CONFIGURATION_EMAIL";
    private final String defaultConfigurationKey = "EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION";
    private final String mailServerKey = "EMAIL_CONFIGURATION_MAIL_SERVER";
    private final String smtpMailServerKey = "EMAIL_CONFIGURATION_SMTP_MAIL_SERVER";
    private final String smtpPortNumberKey = "EMAIL_CONFIGURATION_SMTP_PORT_NUMBER";
    private final String sourceAddressKey = "EMAIL_CONFIGURATION_SOURCE_ADDRESS";
    private final String timeoutKey = "EMAIL_CONFIGURATION_TIMEOUT";
    private final String mailUserKey = "EMAIL_CONFIGURATION_MAIL_USER";
    private final String useSSLKey = "EMAIL_CONFIGURATION_USE_SSL";
    private final String useStartTLSKey = "EMAIL_CONFIGURATION_USE_STARTTLS";
    private final String smtpUserKey = "EMAIL_CONFIGURATION_SMTP_USER";
    private final String debugKey = "EMAIL_CONFIGURATION_DEBUG";
    private final String emailAuthenticationMethodKey = "EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD";
    private final String oauth2ConnectionIdKey = "OAUTH2_CONNECTION_ID";
    private final String bufferedSenderKey = "EMAIL_CONFIGURATION_BUFFERED_SENDER";
    private final String maxAttemptsKey = "EMAIL_CONFIGURATION_MAX_ATTEMPTS";
    private final String periodKey = "EMAIL_CONFIGURATION_PERIOD";
    private final String tryAfterKey = "EMAIL_CONFIGURATION_TRY_AFTER";
    private final String sendCopyKey = "EMAIL_CONFIGURATION_SEND_COPY";
    private final String sendCopyRecipientsKey = "EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS";
    private final String sendCopyRecipientsTypeKey = "EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        Locale locale = LocaleContextHolder.getLocale();
        String id = map.get("EMAIL_CONFIGURATION_ID");
        String name = map.get("EMAIL_CONFIGURATION_NAME");
        String email = map.get("EMAIL_CONFIGURATION_EMAIL");
        String defaultConfiguration = map.get("EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION");
        String mailServer = map.get("EMAIL_CONFIGURATION_MAIL_SERVER");
        String smtpMailServer = map.get("EMAIL_CONFIGURATION_SMTP_MAIL_SERVER");
        String smtpPortNumber = map.get("EMAIL_CONFIGURATION_SMTP_PORT_NUMBER");
        String sourceAddress = map.get("EMAIL_CONFIGURATION_SOURCE_ADDRESS");
        String timeout = map.get("EMAIL_CONFIGURATION_TIMEOUT");
        String mailUser = map.get("EMAIL_CONFIGURATION_MAIL_USER");
        String useSSL = map.get("EMAIL_CONFIGURATION_USE_SSL");
        String useStartTLS = map.get("EMAIL_CONFIGURATION_USE_STARTTLS");
        String smtpUser = map.get("EMAIL_CONFIGURATION_SMTP_USER");
        String debug = map.get("EMAIL_CONFIGURATION_DEBUG");
        String emailAuthenticationMethod = map.get("EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD");
        String oauth2ConnectionId = map.get("OAUTH2_CONNECTION_ID");
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_ID.toString(), id);
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_NAME.toString(), this.formatTextValueChange(name));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_EMAIL.toString(), this.formatTextValueChange(email));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_DEFAULT_CONFIGURATION.toString(), this.translateBooleanValue(defaultConfiguration, locale));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_MAIL_SERVER.toString(), this.formatTextValueChange(mailServer));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SMTP_MAIL_SERVER.toString(), this.formatTextValueChange(smtpMailServer));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SMTP_PORT_NUMBER.toString(), this.formatTextValueChange(smtpPortNumber));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SOURCE_ADDRESS.toString(), this.formatTextValueChange(sourceAddress));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_TIMEOUT.toString(), this.formatTextValueChange(timeout));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_MAIL_USER.toString(), this.formatTextValueChange(mailUser));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_USE_SSL.toString(), this.translateBooleanValue(useSSL, locale));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_USE_STARTTLS.toString(), this.translateBooleanValue(useStartTLS, locale));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SMTP_USER.toString(), this.formatTextValueChange(smtpUser));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_DEBUG.toString(), this.translateBooleanValue(debug, locale));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_EMAIL_AUTHENTICATION_METHOD.toString(), this.formatTextValueChange(emailAuthenticationMethod));
        if (oauth2ConnectionId != null) {
            formattedMap.put(AuditParamsNames.OAUTH2_CONNECTION_ID.toString(), this.formatTextValueChange(oauth2ConnectionId));
        }
        String bufferedSender = map.get("EMAIL_CONFIGURATION_BUFFERED_SENDER");
        String maxAttempts = map.get("EMAIL_CONFIGURATION_MAX_ATTEMPTS");
        String period = map.get("EMAIL_CONFIGURATION_PERIOD");
        String tryAfter = map.get("EMAIL_CONFIGURATION_TRY_AFTER");
        String sendCopy = map.get("EMAIL_CONFIGURATION_SEND_COPY");
        String sendCopyRecipients = map.get("EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS");
        String sendCopyRecipientsType = map.get("EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE");
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_BUFFERED_SENDER.name(), this.translateBooleanValue(bufferedSender, locale));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_MAX_ATTEMPTS.name(), this.formatTextValueChange(maxAttempts));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_PERIOD.name(), this.formatTextValueChange(period));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_TRY_AFTER.name(), this.formatTextValueChange(tryAfter));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SEND_COPY.name(), this.formatTextValueChange(sendCopy));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS.name(), this.formatTextValueChange(sendCopyRecipients));
        formattedMap.put(AuditParamsNames.EMAIL_CONFIGURATION_SEND_COPY_RECIPIENTS_TYPE.name(), this.formatTextValueChange(sendCopyRecipientsType));
        return formattedMap;
    }
}

