/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertDocumentViewFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertDocumentViewFormatter.class);
    private final String idKey = "documentViewId";
    private final String processDefIdKey = "proc_def_id";
    private final String nameKey = "document_view_name";
    private final String descriptionKey = "document_view_desc";
    private final String userIdKey = "user_id";
    private final String activityDefIdKey = "task_def_id";
    private final String documentClassIdKey = "doc_class_id";
    private final String showOnKey = "showOn";
    private final String isDescendingKey = "is_descending";
    private final String amountKey = "amount";
    private final String regexKey = "regex";
    private final String displayByOffice365Key = "displayByOffice365";
    private final String displayByGoogleDocsKey = "displayByGoogleDocs";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("documentViewId");
            String processDefId = map.get("proc_def_id");
            String name = map.get("document_view_name");
            String description = map.get("document_view_desc");
            String activityDefId = map.get("task_def_id");
            String userId = map.get("user_id");
            String documentClassId = map.get("doc_class_id");
            String showOn = map.get("showOn");
            String isDescending = map.get("is_descending");
            String amount = map.get("amount");
            String regex = map.get("regex");
            String displayByOffice365 = map.get("displayByOffice365");
            String displayByGoogleDocs = map.get("displayByGoogleDocs");
            if (StringUtils.isBlank((CharSequence)isDescending)) {
                isDescending = "OFF";
            }
            Locale locale = LocaleContextHolder.getLocale();
            I18Nxpdl xpdl = new I18Nxpdl(locale);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.DOCUMENT_VIEW_ID.toString(), id);
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getTranslatedProcessName(processDefId, xpdl));
            formattedMap.put(AuditParamsNames.DOCUMENT_VIEW_NAME.toString(), name);
            formattedMap.put(AuditParamsNames.DOCUMENT_VIEW_DESCR.toString(), description);
            formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), this.getTranslatedActivityName(processDefId, activityDefId, xpdl));
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), this.getDocumentClassName(documentClassId));
            formattedMap.put(AuditParamsNames.SHOW_ON.toString(), this.getShowOnName(showOn));
            formattedMap.put(AuditParamsNames.IS_DESCENDING.toString(), this.translateBooleanValue(isDescending, LocaleContextHolder.getLocale()));
            formattedMap.put(AuditParamsNames.AMOUNT.toString(), amount);
            formattedMap.put(AuditParamsNames.REGEX.toString(), regex);
            formattedMap.put(AuditParamsNames.DISPLAY_BY_OFFICE_365.toString(), this.translateBooleanValue(displayByOffice365, LocaleContextHolder.getLocale()));
            formattedMap.put(AuditParamsNames.DISPLAY_BY_GOOGLE_DOCS.toString(), this.translateBooleanValue(displayByGoogleDocs, LocaleContextHolder.getLocale()));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getTranslatedProcessName(String processDefId, I18Nxpdl xpdl) {
        if (processDefId != null && processDefId.split(";", -1).length > 1) {
            String[] processDefIds = processDefId.split(";", -1);
            return this.getProcessNameValue(processDefIds[0], xpdl) + " > " + this.getProcessNameValue(processDefIds[1], xpdl);
        }
        return this.getProcessNameValue(processDefId, xpdl);
    }

    private String getProcessNameValue(String processDefId, I18Nxpdl xpdl) {
        if (StringUtils.isBlank((CharSequence)processDefId) || processDefId.equals("null")) {
            Locale locale = LocaleContextHolder.getLocale();
            return MessageHelper.getMessage((String)"Kazde", (Locale)locale, (Object[])new Object[0]);
        }
        return this.getProcessName(processDefId, xpdl);
    }

    private String getTranslatedActivityName(String processDefId, String activityDefId, I18Nxpdl xpdl) {
        String oldProcessDefId = processDefId;
        String newProcessDefId = processDefId;
        if (processDefId != null && processDefId.split(";", -1).length > 1) {
            String[] processDefIds = processDefId.split(";", -1);
            oldProcessDefId = processDefIds[0];
            newProcessDefId = processDefIds[1];
        }
        if (activityDefId != null && activityDefId.split(";", -1).length > 1) {
            String[] activities = activityDefId.split(";", -1);
            return this.getActivityNameValue(oldProcessDefId, activities[0], xpdl) + " > " + this.getActivityNameValue(newProcessDefId, activities[1], xpdl);
        }
        return this.getActivityNameValue(processDefId, activityDefId, xpdl);
    }

    private String getActivityNameValue(String processDefId, String activityDefId, I18Nxpdl xpdl) {
        if (StringUtils.isBlank((CharSequence)activityDefId)) {
            Locale locale = LocaleContextHolder.getLocale();
            return MessageHelper.getMessage((String)"Kazde", (Locale)locale, (Object[])new Object[0]);
        }
        return this.getActivityName(processDefId, activityDefId, xpdl);
    }

    private String getShowOnName(String showOn) {
        if (showOn != null && showOn.split(";", -1).length > 1) {
            String[] showOns = showOn.split(";", -1);
            return MessageHelper.getMessage((String)showOns[0]) + " > " + MessageHelper.getMessage((String)showOns[1]);
        }
        return MessageHelper.getMessage((String)showOn);
    }

    private String getDocumentClassName(String documentClassId) {
        if (StringUtils.isNotBlank((CharSequence)documentClassId) && documentClassId.split(";", -1).length > 1) {
            String[] documentClassIds = documentClassId.split(";", -1);
            return this.getDocumentClassNameValue(documentClassIds[0]) + " > " + this.getDocumentClassNameValue(documentClassIds[1]);
        }
        return this.getDocumentClassNameValue(documentClassId);
    }

    private String getDocumentClassNameValue(String documentClassId) {
        if (StringUtils.isBlank((CharSequence)documentClassId)) {
            Locale locale = LocaleContextHolder.getLocale();
            return MessageHelper.getMessage((String)"Kazda", (Locale)locale, (Object[])new Object[0]);
        }
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
        if (documentClass != null) {
            return documentClass.getName();
        }
        return documentClassId;
    }
}

