/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class SaveViewFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(SaveViewFormatter.class);
    private final String viewIdKey = "viewId";
    private final String nameKey = "searchViewName";
    private final String descriptionKey = "searchViewDescr";
    private final String showFormOnResultKey = "showFormOnResult";
    private final String showSearchResultOnResultKey = "showSearchResultOnResult";
    private final String acceptManyTasksKey = "acceptManyTasks";
    private final String acceptFromAllPagesKey = "acceptFromAllPages";
    private final String showOnlyLatestActivityDetailsKey = "showOnlyLatestActivityDetails";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String showFormOnResult = map.get("showFormOnResult");
            String showSearchResultOnResult = map.get("showSearchResultOnResult");
            String acceptManyTasks = map.get("acceptManyTasks");
            String acceptFromAllPages = map.get("acceptFromAllPages");
            String showOnlyLatestActivityDetails = map.get("showOnlyLatestActivityDetails");
            showFormOnResult = this.validateBooleanParam(showFormOnResult);
            showSearchResultOnResult = this.validateBooleanParam(showSearchResultOnResult);
            acceptManyTasks = this.validateBooleanParam(acceptManyTasks);
            acceptFromAllPages = this.validateBooleanParam(acceptFromAllPages);
            showOnlyLatestActivityDetails = this.validateBooleanParam(showOnlyLatestActivityDetails);
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.VIEW_ID.toString(), map.get("viewId"));
            formattedMap.put(AuditParamsNames.VIEW_NAME.toString(), map.get("searchViewName"));
            formattedMap.put(AuditParamsNames.VIEW_DESCR.toString(), map.get("searchViewDescr"));
            formattedMap.put(AuditParamsNames.VIEW_SHOW_FORM.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(showFormOnResult.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.VIEW_SHOW_SEARCH.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(showSearchResultOnResult.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.VIEW_ACCEPT_MANY_TASKS.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(acceptManyTasks.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.ACCEPT_FROM_ALL_PAGES.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(acceptFromAllPages.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.SHOW_ONLY_LATEST_ACTIVITY_DETAILS.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(showOnlyLatestActivityDetails.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String validateBooleanParam(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return "FALSE";
        }
        return param;
    }
}

