/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(MappingFormatter.class);
    private final String usernameKey = "userName";
    private final String firstNameKey = "firstName";
    private final String lastNameKey = "lastName";
    private final String groupKey = "group";
    private final String positionNameKey = "positionName";
    private final String positionSymbolKey = "positionSymbol";
    private final String organizationalUnitNameKey = "organizationalUnitName";
    private final String organizationalUnitSymbolKey = "organizationalUnitSymbol";
    private final String roleIdKey = "roleId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String username = map.get("userName");
            String firstName = map.get("firstName");
            String lastName = map.get("lastName");
            String group = map.get("group");
            String positionName = map.get("positionName");
            String positionSymbol = map.get("positionSymbol");
            String organizationalUnitName = map.get("organizationalUnitName");
            String organizationalUnitSymbol = map.get("organizationalUnitSymbol");
            String roleId = map.get("roleId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USERNAME.name(), username);
            formattedMap.put(AuditParamsNames.USERFIRSTNAME.name(), firstName);
            formattedMap.put(AuditParamsNames.USERLASTNAME.name(), lastName);
            formattedMap.put(AuditParamsNames.USERGROUPNAME.name(), group);
            formattedMap.put(AuditParamsNames.POSITION_NAME.name(), positionName);
            formattedMap.put(AuditParamsNames.POSITIONSYMBOL.name(), positionSymbol);
            formattedMap.put(AuditParamsNames.ORGUNITNAME.name(), organizationalUnitName);
            formattedMap.put(AuditParamsNames.ORGUNITSYMBOL.name(), organizationalUnitSymbol);
            formattedMap.put(AuditParamsNames.ROLE_NAME.name(), roleId);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

