/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertPanelParameterFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UpsertPanelParameterFormatter.class);
    private final String panelParameterId = "panelParameterId";
    private final String parameterName = "parameterName";
    private final String parameterType = "parameterType";
    private final String parameterParam = "parameterParam";
    private final String parameterIsCount = "parameterIsCount";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PANEL_PARAMETER_ID.toString(), map.get("panelParameterId"));
            formattedMap.put(AuditParamsNames.PANEL_PARAMETER_NAME.toString(), this.getCustomName(map.get("parameterName")));
            formattedMap.put(AuditParamsNames.PANEL_PARAMETER_TYPE.toString(), this.getCustomName(map.get("parameterType")));
            formattedMap.put(AuditParamsNames.PANEL_PARAMETER_PARAM.toString(), this.getCustomName(map.get("parameterParam")));
            formattedMap.put(AuditParamsNames.PANEL_PARAMETER_IS_COUNT.toString(), this.translateBooleanValue(map.get("parameterIsCount"), LocaleContextHolder.getLocale()));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

