/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarResourceGroupFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(CalendarResourceGroupFormatter.class);
    private final String idKey = "id";
    private final String nameKey = "name";
    private final String parentResourceGroupIdKey = "parentResourceGroupId";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String id = map.get("id");
            String name = map.get("name");
            String parentResourceGroupId = map.get("parentResourceGroupId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_GROUP_ID.name(), this.formatTextValueChange(id));
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_GROUP_NAME.name(), this.formatTextValueChange(name));
            }
            if (StringUtils.isNotBlank((CharSequence)parentResourceGroupId)) {
                formattedMap.put(AuditParamsNames.CALENDAR_RESOURCE_GROUP_PARENT_RESOURCE_GROUP_ID.name(), this.formatTextValueChange(parentResourceGroupId));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

