/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.servlet;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.object.AuditFetchResult;
import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.service.AuditService;
import com.suncode.pwfl.audit.util.AuditServiceFactory;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAudits
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(GetAudits.class);
    private static final long serialVersionUID = 1L;
    private final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.trace("************************* GetAudits Servlet ****************************");
        PrintWriter printWriter = null;
        JSONArray jsonAudits = null;
        long lCount = 0L;
        String orderBy = "auditStarted";
        String sortDirection = "DESC";
        boolean isAscending = false;
        try {
            jsonAudits = new JSONArray();
            String sortInfo = request.getParameter("sort");
            String start = request.getParameter("start");
            String limit = request.getParameter("limit");
            int iStart = Integer.parseInt(start);
            int iLimit = Integer.parseInt(limit);
            if (sortInfo != null) {
                JSONArray jsonSort = new JSONArray(sortInfo);
                JSONObject jsonSortInfo = (JSONObject)jsonSort.get(0);
                orderBy = jsonSortInfo.getString("property");
                sortDirection = jsonSortInfo.getString("direction");
            }
            if (sortDirection.equalsIgnoreCase("ASC")) {
                isAscending = true;
            }
            FilterConfig filterConfig = AuditTools.buildFilterConfig((HttpServletRequest)request);
            AuditService auditService = AuditServiceFactory.getAuditService();
            AuditFetchResult auditFetchResult = auditService.getAudits(orderBy, isAscending, iStart, iLimit, filterConfig);
            lCount = auditFetchResult.getCount();
            List audits = auditFetchResult.getAudits();
            if (orderBy.equals("auditStarted") && !isAscending) {
                Comparator<Audit> comparator = Comparator.comparing(audit -> LocalDateTime.ofInstant(Instant.ofEpochMilli(audit.getAuditStarted()), ZoneId.systemDefault()).truncatedTo(ChronoUnit.SECONDS)).thenComparing(audit -> LocalDateTime.ofInstant(Instant.ofEpochMilli(audit.getAuditStopped()), ZoneId.systemDefault())).reversed();
                audits.sort(comparator);
            }
            for (Audit audit2 : audits) {
                JSONObject jsonAudit = new JSONObject();
                jsonAudit.put("auditId", (Object)String.valueOf(audit2.getId()));
                jsonAudit.put("userId", (Object)StringEscapeUtils.escapeXml((String)String.valueOf(audit2.getUserId())));
                jsonAudit.put("ipAddress", (Object)String.valueOf(audit2.getIpAddress()));
                jsonAudit.put("threadId", (Object)String.valueOf(audit2.getThreadId()));
                jsonAudit.put("auditType", (Object)AuditTypes.getTranslatedAuditType((String)audit2.getAuditType()));
                jsonAudit.put("auditStarted", (Object)this.simpleDateFormat.format(new Date(audit2.getAuditStarted())));
                jsonAudit.put("auditStopped", (Object)this.simpleDateFormat.format(new Date(audit2.getAuditStopped())));
                jsonAudit.put("auditDuration", (Object)AuditTools.getDurationValue((long)audit2.getAuditDuration()));
                jsonAudit.put("auditSuccess", audit2.isAuditSuccess());
                jsonAudits.put((Object)jsonAudit);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                JSONObject jsonAnswer = new JSONObject();
                jsonAnswer.put("audits", (Object)jsonAudits);
                jsonAnswer.put("total", lCount);
                response.setContentType("application/json;charset=UTF-8");
                printWriter = response.getWriter();
                printWriter.print(jsonAnswer);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

