/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.service;

import com.suncode.plugin.framework.service.Provides;
import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.AuditFinder;
import com.suncode.pwfl.audit.dao.AuditDao;
import com.suncode.pwfl.audit.detail.AuditDetails;
import com.suncode.pwfl.audit.dto.AuditDetailDto;
import com.suncode.pwfl.audit.dto.AuditDto;
import com.suncode.pwfl.audit.object.AuditFetchResult;
import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.util.AuditCategories;
import com.suncode.pwfl.audit.util.AuditSortProperty;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.translation.Translator;
import com.suncode.pwfl.translation.TranslatorScope;
import com.suncode.pwfl.translation.Translators;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="auditFinder")
@Provides(value={AuditFinder.class})
public class AuditFinderImpl
extends EditableServiceImpl<Audit, Long, AuditDao>
implements AuditFinder {
    @Autowired
    public void setDao(AuditDao dao) {
        this.dao = dao;
    }

    @Transactional
    public CountedResult<AuditDto> getAuditsByTypes(List<AuditTypes> auditTypes, LocalDateTime auditStart, LocalDateTime auditStop, Integer offset, Integer limit, AuditSortProperty auditSortProperty, SortDirection sortDirection) {
        FilterConfig filterConfig = new FilterConfig();
        Assert.notNull((Object)auditStart, (String)"Start date cannot be null");
        Assert.notNull((Object)auditStop, (String)"Stop date cannot be null");
        filterConfig.setAuditStartedFrom(Timestamp.valueOf(auditStart).getTime());
        filterConfig.setAuditStoppedTo(Timestamp.valueOf(auditStop).getTime());
        filterConfig.setAuditTypes(auditTypes.stream().map(Enum::toString).collect(Collectors.toList()));
        String sortProperty = auditSortProperty != null ? auditSortProperty.getColumn() : null;
        boolean isAsc = sortDirection == SortDirection.ASC;
        AuditFetchResult results = ((AuditDao)this.dao).getAudits(sortProperty, isAsc, offset.intValue(), limit.intValue(), filterConfig);
        return new CountedResult(results.getCount(), results.getAudits().stream().map(arg_0 -> this.buildAuditDto(arg_0)).collect(Collectors.toList()));
    }

    @Transactional
    public CountedResult<AuditDto> getAuditsByCategories(List<AuditCategories> auditCategories, LocalDateTime auditStart, LocalDateTime auditStop, Integer start, Integer limit, AuditSortProperty auditSortProperty, SortDirection sortDirection) {
        ArrayList types = new ArrayList();
        for (AuditCategories category : auditCategories) {
            types.addAll(AuditTypes.getByCategory((AuditCategories)category));
        }
        return this.getAuditsByTypes(types, auditStart, auditStop, start, limit, auditSortProperty, sortDirection);
    }

    public CountedResult<AuditDto> getAudits(LocalDateTime auditStart, LocalDateTime auditStop, Integer start, Integer limit, AuditSortProperty auditSortProperty, SortDirection sortDirection) {
        return this.getAuditsByTypes(new ArrayList(), auditStart, auditStop, start, limit, auditSortProperty, sortDirection);
    }

    private AuditDto buildAuditDto(Audit audit) {
        AuditDto dto = new AuditDto();
        dto.setType(audit.getAuditType());
        dto.setTranslatedName(AuditTypes.getTranslatedAuditType((String)audit.getAuditType()));
        dto.setStarted(new Date(audit.getAuditStarted()));
        dto.setStopped(new Date(audit.getAuditStopped()));
        dto.setDuration(Long.valueOf(audit.getAuditDuration()));
        dto.setSuccess(Boolean.valueOf(audit.isAuditSuccess()));
        dto.setIpAddress(audit.getIpAddress());
        dto.setThread(audit.getThreadId());
        dto.setUserName(audit.getUserId());
        dto.setAuditDetails(this.buildAuditDetails(audit.getAuditParams(), audit.getAuditType()));
        return dto;
    }

    private List<AuditDetailDto> buildAuditDetails(String auditParams, String type) {
        List translators = Translators.getAll((TranslatorScope)TranslatorScope.SERVER);
        if (AuditTools.isDefinedAudit((String)type)) {
            return this.buildSystemAuditDetails(new AuditDetails(AuditTypes.valueOf((String)type)), auditParams, translators);
        }
        return this.buildPluginAuditDetails(auditParams, translators);
    }

    private List<AuditDetailDto> buildSystemAuditDetails(AuditDetails details, String auditParams, List<Translator> translators) {
        return details.decompose(auditParams).stream().filter(param -> !"AUDIT_PARAM_".equalsIgnoreCase(param.getParamName()) && StringUtils.isNotBlank((String)param.getParamValue())).map(param -> new AuditDetailDto(AuditTools.getParamTranslation((String)param.getParamName(), (List)translators), param.getParamName(), param.getParamValue())).collect(Collectors.toList());
    }

    private List<AuditDetailDto> buildPluginAuditDetails(String auditParams, List<Translator> translators) {
        return Arrays.asList(auditParams.split("@AUDIT_PARAM@")).stream().map(auditParam -> this.buildAuditDetailsDto(auditParam, translators)).collect(Collectors.toList());
    }

    private AuditDetailDto buildAuditDetailsDto(String auditParam, List<Translator> translators) {
        String[] splittedParam = auditParam.split("=", -1);
        String paramName = splittedParam[0];
        String paramValue = splittedParam[1];
        return new AuditDetailDto(AuditTools.getParamTranslation((String)paramName, translators), paramName, AuditTools.getParamTranslation((String)paramValue, translators));
    }
}

