/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.request;

import com.suncode.pwfl.audit.form.RequestParamsHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RequestParamsAnalyzer
implements RequestParamsHandler {
    public static Logger log = Logger.getLogger(RequestParamsAnalyzer.class);
    protected static final List<String> parameterNamesToSkip = Arrays.asList("password");

    public String getApplicationEnctypeParamsString(HttpServletRequest request) {
        StringBuffer auditParamsBuffer = new StringBuffer("");
        Map parametersMap = request.getParameterMap();
        Set parametersSet = parametersMap.keySet();
        for (Object parameterName : parametersSet) {
            String[] parameterValuesTab;
            Object parameterValue;
            if (this.parameterShouldBeSkipped(parameterName) || (parameterValue = parametersMap.get(parameterName)) == null) continue;
            if (parameterValue instanceof String) {
                auditParamsBuffer.append(parameterName.toString());
                auditParamsBuffer.append("=");
                auditParamsBuffer.append(parameterValue.toString());
                auditParamsBuffer.append("@AUDIT_PARAM@");
                continue;
            }
            if (!(parameterValue instanceof String[])) continue;
            for (String valueInTab : parameterValuesTab = (String[])parameterValue) {
                auditParamsBuffer.append(parameterName.toString());
                auditParamsBuffer.append("=");
                auditParamsBuffer.append(valueInTab);
                auditParamsBuffer.append("@AUDIT_PARAM@");
            }
        }
        return auditParamsBuffer.toString();
    }

    private boolean parameterShouldBeSkipped(Object parameterName) {
        return parameterNamesToSkip.contains(parameterName.toString());
    }

    public String format(String paramsString) {
        if (paramsString.endsWith("@AUDIT_PARAM@")) {
            return paramsString.substring(0, paramsString.length() - "@AUDIT_PARAM@".length());
        }
        return paramsString;
    }

    public boolean isApplicationEnctypeParamPresent(HttpServletRequest request, String paramName) {
        return !StringUtils.isBlank((String)request.getParameter(paramName));
    }
}

