/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateActivityFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(ValidateActivityFormatter.class);
    private final String processIdKey = "processId";
    private final String activityIdKey = "activityId";
    private final String checkFormKey = "checkForm";
    private final String actionNameKey = "actionName";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processId = map.get("processId");
            String activityId = map.get("activityId");
            String checkForm = map.get("checkForm");
            String actionName = map.get("actionName");
            if (StringUtils.isBlank((String)checkForm)) {
                checkForm = "FALSE";
            }
            ActivityDef activityDef = new ActivityDef(processId, activityId);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessName());
            formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
            formattedMap.put(AuditParamsNames.CHECK_FORM.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(checkForm.toUpperCase())));
            formattedMap.put(AuditParamsNames.ACTIONNAME.toString(), actionName);
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

