/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

/*
 * Exception performing whole class analysis ignored.
 */
public class UpdateDocClassFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(UpdateDocClassFormatter.class);
    private final String docclassIdKey = "docclassId";
    private final String docclassNameKey = "docclassName";
    private final String docclassDescrKey = "docclassDescr";
    private final String maxFileSizeKey = "maxFileSize";
    private final String expireDocumentTypeKey = "expireDocumentType";
    private final String docclassExpiretionKey = "docclassExpiretion";
    private final String docclassExpiretion2Key = "docclassExpiretion2";
    private final String docclassExpiretion3Key = "docclassExpiretion3";
    private final String directoryNameKey = "directoryName";
    private final String docclassEncodingKey = "docclassEncoding";
    private final String docclassComperssingKey = "docclassComperssing";
    private final String cipherAlgorithmKey = "cipherAlgorithm";
    private final String keyLenghtKey = "keyLenght";
    private final String logicalConnectionKey = "logicalConnection";
    private final String docclassIndexingKey = "docclassIndexing";
    private final String iconKey = "icon";
    private final String iconColorKey = "iconColor";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String docclassId = map.get("docclassId");
            String docclassName = map.get("docclassName");
            String docclassDescr = map.get("docclassDescr");
            String maxFileSize = map.get("maxFileSize");
            String expireDocumentType = map.get("expireDocumentType");
            String docclassExpiretion = map.get("docclassExpiretion");
            String docclassExpiretion2 = map.get("docclassExpiretion2");
            String docclassExpiretion3 = map.get("docclassExpiretion3");
            String directoryName = map.get("directoryName");
            String docclassEncoding = map.get("docclassEncoding");
            String docclassComperssing = map.get("docclassComperssing");
            String cipherAlgorithm = map.get("cipherAlgorithm");
            String keyLenght = map.get("keyLenght");
            String logicalConnection = map.get("logicalConnection");
            String docclassIndexing = map.get("docclassIndexing");
            String iconName = map.get("icon");
            String iconColor = map.get("iconColor");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), docclassId);
            formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), this.getCustomName(docclassName));
            formattedMap.put(AuditParamsNames.DOCCLASSDESCR.toString(), this.getCustomName(docclassDescr));
            formattedMap.put(AuditParamsNames.MAXFILESIZE.toString(), maxFileSize);
            formattedMap.put(AuditParamsNames.EXPIREDOCUMENTTYPE.toString(), UpdateDocClassFormatter.translateExpirationType((String)expireDocumentType));
            formattedMap.put(AuditParamsNames.DOCCLASSEXPIRETION.toString(), docclassExpiretion);
            formattedMap.put(AuditParamsNames.DOCCLASSEXPIRETION2.toString(), docclassExpiretion2);
            formattedMap.put(AuditParamsNames.DOCCLASSEXPIRETION3.toString(), docclassExpiretion3);
            formattedMap.put(AuditParamsNames.DOC_CLASS_DIRECTORY_NAME.toString(), directoryName);
            formattedMap.put(AuditParamsNames.DOCCLASSENCODING.toString(), this.translateBooleanValue(docclassEncoding, locale));
            formattedMap.put(AuditParamsNames.DOCCLASSCOMPERSSING.toString(), this.translateBooleanValue(docclassComperssing, locale));
            formattedMap.put(AuditParamsNames.CIPHERALGORITHM.toString(), cipherAlgorithm);
            formattedMap.put(AuditParamsNames.KEYLENGHT.toString(), keyLenght);
            formattedMap.put(AuditParamsNames.LOGICALCONNECTION.toString(), logicalConnection);
            formattedMap.put(AuditParamsNames.DOCCLASSINDEXING.toString(), this.translateBooleanValue(docclassIndexing, locale));
            formattedMap.put(AuditParamsNames.ICON.toString(), this.getCustomName(iconName));
            formattedMap.put(AuditParamsNames.ICON_COLOR.toString(), this.getCustomName(iconColor));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    static String translateExpirationType(String expirationType) {
        if (StringUtils.isNotBlank((String)expirationType) && expirationType.split(";", -1).length > 1) {
            String[] expirationTypes = expirationType.split(";", -1);
            return UpdateDocClassFormatter.translateExpirationTypeName((String)expirationTypes[0]) + " > " + UpdateDocClassFormatter.translateExpirationTypeName((String)expirationTypes[1]);
        }
        return UpdateDocClassFormatter.translateExpirationTypeName((String)expirationType);
    }

    static String translateExpirationTypeName(String expirationType) {
        switch (expirationType) {
            case "dayCnt": {
                return MessageHelper.getMessage((String)"AUDIT_PARAM_DOCCLASSEXPIRETION");
            }
            case "endDay": {
                return MessageHelper.getMessage((String)"AUDIT_PARAM_DOCCLASSEXPIRETION2");
            }
            case "period": {
                return MessageHelper.getMessage((String)"AUDIT_PARAM_DOCCLASSEXPIRETION3");
            }
        }
        return MessageHelper.getMessage((String)"Brak");
    }
}

