/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class DeleteDocumentTemplateFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DeleteDocumentTemplateFormatter.class);
    private final String processDefIdKey = "processId";
    private final String templateIdKey = "docTemplateId";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processDefId = map.get("processId");
            Locale locale = LocaleContextHolder.getLocale();
            I18Nxpdl xpdl = new I18Nxpdl(locale);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.getProcessName(processDefId, xpdl));
            formattedMap.put(AuditParamsNames.DOCUMENT_TEMPLATE_ID.toString(), map.get("docTemplateId"));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

