/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddScheduledTaskFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddScheduledTaskFormatter.class);
    private final String classnameKey = "classname";
    private final String methodKey = "method";
    private final String nameKey = "name";
    private final String descriptionKey = "description";
    private final String categoryKey = "categoryName";
    private final String firstRunKey = "firstRun";
    private final String periodValueKey = "periodValue";
    private final String periodUnitKey = "periodUnit";
    private final String activeKey = "active";
    private final String saveHistoryKey = "savehistory";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String periodValue = map.get("periodValue");
            String periodUnit = map.get("periodUnit");
            String active = map.get("active");
            String saveHistory = map.get("savehistory");
            active = this.validateOnOffValue(active);
            saveHistory = this.validateOnOffValue(saveHistory);
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.CLASSNAME.toString(), map.get("classname"));
            formattedMap.put(AuditParamsNames.METHOD.toString(), map.get("method"));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_NAME.toString(), map.get("name"));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_DESCR.toString(), map.get("description"));
            formattedMap.put(AuditParamsNames.CATEGORY.toString(), map.get("categoryName"));
            formattedMap.put(AuditParamsNames.FIRST_RUN.toString(), map.get("firstRun"));
            formattedMap.put(AuditParamsNames.PERIOD.toString(), this.buildPeriod(periodValue, periodUnit));
            formattedMap.put(AuditParamsNames.ACTIVE.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(active.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.SCHEDULED_TASK_SAVE_HISTORY.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(saveHistory.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String buildPeriod(String periodValue, String periodUnit) {
        String translatedPeriodUnit = "";
        Locale locale = LocaleContextHolder.getLocale();
        translatedPeriodUnit = StringUtils.equals((CharSequence)periodUnit, (CharSequence)"minute") ? MessageHelper.getOptionalMessage((String)"minuty", (Locale)locale, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"hour") ? MessageHelper.getOptionalMessage((String)"godziny", (Locale)locale, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"day") ? MessageHelper.getOptionalMessage((String)"dni", (Locale)locale, (Object[])new Object[0]) : (StringUtils.equals((CharSequence)periodUnit, (CharSequence)"month") ? MessageHelper.getOptionalMessage((String)"Miesiace_30_dni", (Locale)locale, (Object[])new Object[0]) : new String(periodUnit))));
        return periodValue + " " + translatedPeriodUnit;
    }

    private String validateOnOffValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return "OFF";
        }
        return value;
    }
}

