/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.ViewService;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class AcceptManyActivitiesFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(AcceptManyActivitiesFormatter.class);
    private final String viewIdKey = "viewId";
    private final String processActivityPairKey = "processActivityIds";
    private final String buttonNameKey = "acceptButtonActionName";
    private final String isAcceptFromAllPagesKey = "acceptFromAllPages";
    private final String numberOfAcceptedTasksKey = "numberOfAcceptedTasks";
    private final ViewService viewService = (ViewService)SpringContext.getBean(ViewService.class);

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processActivityPair = map.get("processActivityIds");
            String[] processActivityPairTable = processActivityPair.split(";");
            ActivityDef activityDef = new ActivityDef(processActivityPairTable[0], processActivityPairTable[1]);
            String isAcceptFromAllPages = this.validateBooleanParam(map.get("acceptFromAllPages"));
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            String viewId = map.get("viewId");
            if (StringUtils.isNotBlank((CharSequence)viewId) && StringUtils.isNumeric((CharSequence)viewId)) {
                formattedMap.put(AuditParamsNames.VIEW_NAME.toString(), this.viewService.getViewTranslation(Long.valueOf(viewId), TranslatedFieldType.NAME));
            }
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessDefId());
            formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
            formattedMap.put(AuditParamsNames.BUTTON_NAME.toString(), map.get("acceptButtonActionName"));
            formattedMap.put(AuditParamsNames.NUMBER_OF_ACCEPTED_TASKS.toString(), map.get("numberOfAcceptedTasks"));
            formattedMap.put(AuditParamsNames.ACCEPT_FROM_ALL_PAGES.toString(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(isAcceptFromAllPages.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String validateBooleanParam(String param) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return "FALSE";
        }
        return param;
    }
}

