/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.Link;
import com.suncode.pwfl.archive.LinkService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.SpringContext;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class UpsertLinkIndexFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UpsertLinkIndexFormatter.class);
    private final String linkIdKey = "linkId";
    private final String nameKey = "indexName";
    private final String descriptionKey = "indexDescription";
    private final String typeKey = "indexType";
    private final String valuesKey = "indexValue";
    private final String listType = "list";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String linkId = map.get("linkId");
            String name = map.get("indexName");
            String description = map.get("indexDescription");
            String type = map.get("indexType");
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            Link link = ((LinkService)SpringContext.getBean(LinkService.class)).getLink(Long.valueOf(linkId), new String[0]);
            if (link != null) {
                formattedMap.put(AuditParamsNames.LINK_NAME.toString(), link.getName());
            } else {
                formattedMap.put(AuditParamsNames.LINK_ID.toString(), linkId);
            }
            formattedMap.put(AuditParamsNames.LINK_INDEX_NAME.toString(), name);
            formattedMap.put(AuditParamsNames.LINK_INDEX_DESCR.toString(), description);
            formattedMap.put(AuditParamsNames.LINK_INDEX_TYPE.toString(), this.translateIndexType(type, locale));
            String newType = "";
            if (StringUtils.isNotBlank((String)type) && type.split(";").length > 1) {
                String[] types = type.split(";");
                newType = types[1];
            }
            if (StringUtils.equalsIgnoreCase((String)newType, (String)"list")) {
                formattedMap.put(AuditParamsNames.LINK_INDEX_VALUES.toString(), map.get("indexValue"));
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

