/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.view.ViewService;
import com.suncode.pwfl.view.dto.ViewDto;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class SearchFormatter
extends Formatter {
    private final String isActivitySearchKey = "isActivitySearch";
    private final String viewIdKey = "viewId";
    private final ViewService viewService = (ViewService)SpringContext.getBean(ViewService.class);

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        String viewId;
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)map.get("isActivitySearch"))) {
            boolean isActivitySearch = Boolean.parseBoolean(map.get("isActivitySearch"));
            String searchTypeTranslationKey = isActivitySearch ? "Zadania" : "Procesy";
            formattedMap.put(AuditParamsNames.SEARCH_TYPE.name(), MessageHelper.getMessage((String)searchTypeTranslationKey));
        }
        if (StringUtils.isNotBlank((CharSequence)(viewId = map.get("viewId")))) {
            formattedMap.put(AuditParamsNames.VIEW_ID.name(), viewId);
            ViewDto viewDto = this.viewService.getView(Long.valueOf(viewId));
            if (viewDto != null) {
                formattedMap.put(AuditParamsNames.VIEW_NAME.name(), viewDto.getTranslatedName());
            }
        }
        return formattedMap;
    }
}

