/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class EditUserNotificationsFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(EditUserNotificationsFormatter.class);
    private final String jsonKey = "records";
    private final String processDefIdKey = "processDefId";
    private final String langKey = "lang";
    private final String processEndKey = "processEnd";
    private final String activityEndKey = "activityEnd";
    private final String activityDeliverKey = "activityDeliver";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            I18Nxpdl xpdlI18N = new I18Nxpdl(LocaleContextHolder.getLocale());
            String json = map.get("records");
            if (json != null) {
                JsonObject record = this.getRecord(json);
                String processDefId = record.getAsJsonPrimitive("processDefId").getAsString();
                String language = record.getAsJsonPrimitive("lang").getAsString();
                formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.translateProcessName(processDefId, xpdlI18N));
                formattedMap.put(AuditParamsNames.LANGUAGE.toString(), language);
            } else {
                String processDefId = map.get("processDefId");
                String language = map.get("lang");
                String processEnd = map.get("processEnd");
                String activityEnd = map.get("activityEnd");
                String activityDeliver = map.get("activityDeliver");
                formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), this.translateProcessName(processDefId, xpdlI18N));
                formattedMap.put(AuditParamsNames.LANGUAGE.toString(), language);
                formattedMap.put(AuditParamsNames.PROCESSEND.toString(), processEnd);
                formattedMap.put(AuditParamsNames.ACTIVITYEND.toString(), activityEnd);
                formattedMap.put(AuditParamsNames.ACTIVITYDELIVER.toString(), activityDeliver);
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private JsonObject getRecord(String json) {
        JsonParser parser = new JsonParser();
        return parser.parse(json).getAsJsonObject();
    }

    private String translateProcessName(String processDefId, I18Nxpdl xpdlI18N) {
        return "default_configuration".equals(processDefId) ? MessageHelper.getMessage((String)processDefId) : this.getProcessName(processDefId, xpdlI18N);
    }
}

