/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CheckInDocumentFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(CheckInDocumentFormatter.class);
    private final String processIdKey = "processId";
    private final String activityIdKey = "activityId";
    private final String documentClassIdKey = "docclassId";
    private final String descriptionKey = "description";
    private final String commentKey = "comment";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processId = map.get("processId");
            String activityId = map.get("activityId");
            String description = map.get("description");
            String comment = map.get("comment");
            String documentClassId = map.get("docclassId");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)processId) && StringUtils.isNotBlank((CharSequence)activityId)) {
                ActivityDef activityDef = new ActivityDef(processId, activityId);
                formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessName());
                formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
            } else if (StringUtils.isNotBlank((CharSequence)documentClassId)) {
                DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
                DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
                if (documentClass != null) {
                    formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
                } else {
                    formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
                }
            }
            formattedMap.put(AuditParamsNames.UPLOADED_FILE_DESCR.toString(), description);
            formattedMap.put(AuditParamsNames.COMMENT.toString(), comment);
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

