/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.request;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.form.AuditCreatorHandler;
import com.suncode.pwfl.audit.request.AuditCreator;
import com.suncode.pwfl.audit.request.RequestParamsAnalyzer;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.audit.util.AuditUrls;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.displaytag.util.ParamEncoder;

public class AuditCreator
implements AuditCreatorHandler {
    public Audit createAudit(HttpServletRequest request, AuditUrls auditUrl) {
        RequestParamsAnalyzer analyzer = new RequestParamsAnalyzer();
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        String userId = (String)session.getAttribute("username");
        switch (1.$SwitchMap$com$suncode$pwfl$audit$util$AuditUrls[auditUrl.ordinal()]) {
            case 1: {
                return new Audit(userId, AuditTypes.AUDIT_LOG_OUT);
            }
            case 2: {
                return new Audit(userId, AuditTypes.AUDIT_SAVE_ACTIVITY);
            }
            case 3: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_ACTIVITY);
            }
            case 4: {
                if (request.getMethod().compareTo("POST") != 0 && !this.isExport(request, "task")) {
                    return new Audit(userId, AuditTypes.AUDIT_SEARCH_PROCESSES);
                }
                return null;
            }
            case 5: {
                if (!this.isExport(request, "task") && !this.isExport(request, "group")) {
                    return new Audit(userId, AuditTypes.AUDIT_SEARCH_DOCCLASS);
                }
                return null;
            }
            case 6: {
                if (!this.isExport(request, "task")) {
                    return new Audit(userId, AuditTypes.AUDIT_SEARCH_LINK);
                }
                return null;
            }
            case 7: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_USER);
            }
            case 8: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_SYSTEM_PROTECTION);
            }
            case 9: 
            case 10: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SYSTEM_PROTECTION);
            }
            case 11: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_POSITION);
            }
            case 12: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_POSITION);
            }
            case 13: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ROLE_FROM_POSITION);
            }
            case 14: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_POSITION);
            }
            case 15: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_ORG_UNIT);
            }
            case 16: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_ORG_UNIT);
            }
            case 17: {
                return new Audit(userId, AuditTypes.AUDIT_SEARCH_ORG_UNIT);
            }
            case 18: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK);
            }
            case 19: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DIRECTORY);
            }
            case 20: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DIRECTORY);
            }
            case 21: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DEVICE);
            }
            case 22: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DEVICE);
            }
            case 23: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LDAP_SERVER);
            }
            case 24: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LDAP_SERVER);
            }
            case 25: {
                return new Audit(userId, AuditTypes.AUDIT_STATS);
            }
            case 26: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_ARCHIVE);
            }
            case 27: {
                return new Audit(userId, AuditTypes.AUDIT_CHECKOUT_FILE_FROM_PROCESS);
            }
            case 28: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_NOTIFICATION);
            }
            case 29: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_NOTIFICATION);
            }
            case 30: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_TEMPLATE);
            }
            case 31: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_TEMPLATE);
            }
            case 32: {
                String xaction = request.getParameter("xaction");
                if (StringUtils.equals((CharSequence)xaction, (CharSequence)"globalConfig")) {
                    String value = request.getParameter("value");
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"enable")) {
                        return new Audit(userId, AuditTypes.AUDIT_ENABLE_USER_NOTIFICATIONS);
                    }
                    if (StringUtils.equals((CharSequence)value, (CharSequence)"disable")) {
                        return new Audit(userId, AuditTypes.AUDIT_DISABLE_USER_NOTIFICATIONS);
                    }
                } else if (StringUtils.equals((CharSequence)xaction, (CharSequence)"destroy")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_USER_NOTIFICATIONS);
                }
                return null;
            }
            case 33: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_PROCESS_PROTECTION);
            }
            case 34: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESS_PROTECTION);
            }
            case 35: {
                return new Audit(userId, AuditTypes.AUDIT_UNINSTALL_MODULE);
            }
            case 36: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_COMMENT_TO_ACTIVITY);
            }
            case 37: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_COMMENT_FROM_ACTIVITY);
            }
            case 38: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_PROCESS);
            }
            case 39: {
                return new Audit(userId, AuditTypes.AUDIT_PROCESS_DETAILS);
            }
            case 40: {
                return new Audit(userId, AuditTypes.AUDIT_ACTIVITY_DETAILS);
            }
            case 41: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_FROM_ARCHIVE);
            }
            case 42: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_SEARCHED_DOCUMENTS);
            }
            case 43: {
                return new Audit(userId, AuditTypes.AUDIT_DEACTIVATE_USER);
            }
            case 44: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DEACTIVATED_USER);
            }
            case 45: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_DOCUMENT_INDEXES);
            }
            case 46: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_PROCESSES);
            }
            case 47: {
                return new Audit(userId, AuditTypes.AUDIT_SUSPEND_ACTIVITY);
            }
            case 48: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_ACTIVITY);
            }
            case 49: {
                return new Audit(userId, AuditTypes.AUDIT_ACCEPT_MANY_ACTIVITIES);
            }
            case 50: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_DOCUMENT_VIEW);
            }
            case 51: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_DOCUMENT_VIEW);
            }
            case 52: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW);
            }
            case 53: {
                return new Audit(userId, AuditTypes.AUDIT_LOAD_LICENSE);
            }
            case 54: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_INDEX);
            }
            case 55: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_INDEX);
            }
            case 56: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_CONNECTION);
            }
            case 57: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_CONNECTION);
            }
            case 58: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_LINK_PROTECTION);
            }
            case 59: {
                return new Audit(userId, AuditTypes.AUDIT_EDIT_LINK_PROTECTION);
            }
            case 60: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_LINK_PROTECTION);
            }
            case 61: {
                String change = request.getParameter("change");
                if (StringUtils.isNotBlank((CharSequence)change)) {
                    return new Audit(userId, AuditTypes.AUDIT_CHANGE_PASSWORD);
                }
                return null;
            }
            case 62: {
                String packageAction = request.getParameter("actionType");
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"loadPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_LOAD_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"updatePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_UPDATE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"closePackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLOSE_PACKAGE);
                }
                if (StringUtils.equals((CharSequence)packageAction, (CharSequence)"clearPackage")) {
                    return new Audit(userId, AuditTypes.AUDIT_CLEAR_PACKAGE);
                }
                return null;
            }
            case 63: {
                String viewIdAddReport = request.getParameter("viewId");
                String sqlQueryAddReport = request.getParameter("sqlQuery");
                if (StringUtils.isNotBlank((CharSequence)viewIdAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryAddReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SQL_QUERY_REPORT);
                }
                return null;
            }
            case 64: {
                String reportIdAddJasperReport = request.getParameter("reportId");
                if (StringUtils.isBlank((CharSequence)reportIdAddJasperReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_JASPER_REPORT);
                }
                return new Audit(userId, AuditTypes.AUDIT_EDIT_JASPER_REPORT);
            }
            case 65: 
            case 66: {
                String viewIdRunReport = request.getParameter("viewId");
                String sqlQueryRunReport = request.getParameter("sqlQuery");
                String reportIdRunReport = request.getParameter("reportId");
                if (StringUtils.isNotBlank((CharSequence)viewIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_VIEW_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)sqlQueryRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_SQL_QUERY_REPORT);
                }
                if (StringUtils.isNotBlank((CharSequence)reportIdRunReport)) {
                    return new Audit(userId, AuditTypes.AUDIT_RUN_JASPER_REPORT);
                }
                return null;
            }
            case 67: {
                return new Audit(userId, AuditTypes.AUDIT_RUN_SAVED_REPORT);
            }
            case 68: {
                return new Audit(userId, AuditTypes.AUDIT_FILTER_REPORT);
            }
            case 69: {
                return new Audit(userId, AuditTypes.AUDIT_ADD_MODULE_RIGHT);
            }
            case 70: {
                return new Audit(userId, AuditTypes.AUDIT_DELETE_MODULE_RIGHT);
            }
            case 71: {
                if (request.getMethod().compareTo("POST") == 0) {
                    return new Audit(userId, AuditTypes.AUDIT_ADD_SCHEDULED_TASK);
                }
                return null;
            }
            case 72: {
                String scheduledTaskAction = request.getParameter("action");
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"remove")) {
                    return new Audit(userId, AuditTypes.AUDIT_DELETE_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"execute")) {
                    return new Audit(userId, AuditTypes.AUDIT_MANUAL_RUN_SCHEDULED_TASK);
                }
                if (StringUtils.equals((CharSequence)scheduledTaskAction, (CharSequence)"cancel")) {
                    return new Audit(userId, AuditTypes.AUDIT_STOP_SCHEDULED_TASK);
                }
                return null;
            }
            case 73: {
                Principal principal = request.getUserPrincipal();
                if (principal != null) {
                    String domainName = this.getAutoLoginAuditDomainName(principal);
                    String userName = request.getRemoteUser();
                    userId = new String(domainName + "/" + userName);
                    return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_IN);
                }
                return null;
            }
            case 74: {
                return new Audit(userId, AuditTypes.AUDIT_AUTO_LOG_OUT);
            }
            case 75: {
                return new Audit(userId, AuditTypes.AUDIT_ABORT_PROCESSES);
            }
        }
        return null;
    }

    private boolean isExport(HttpServletRequest request, String paramName) {
        String exportType = new ParamEncoder(paramName).encodeParameterName("e");
        String isExport = request.getParameter(exportType);
        return !StringUtils.isBlank((CharSequence)isExport);
    }

    private String getAutoLoginAuditDomainName(Principal principal) {
        String[] splittedPrincipalName = principal.getName().split("@");
        int dotPos = splittedPrincipalName[1].indexOf(".");
        if (dotPos != -1) {
            return StringUtils.lowerCase((String)splittedPrincipalName[1].substring(0, dotPos));
        }
        return StringUtils.lowerCase((String)splittedPrincipalName[1]);
    }
}

