/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(DirectoryFormatter.class);
    private final String directoryIdKey = "directoryId";
    private final String directoryNameKey = "directoryName";
    private final String directorySizeKey = "directorySize";
    private final String directoryThresholdKey = "directoryThreshold";
    private final String rootDirectoryKey = "rootDirectory";
    private final String deviceKey = "device";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String directoryId = map.get("directoryId");
            String directoryName = map.get("directoryName");
            String directorySize = map.get("directorySize");
            String directoryThreshold = map.get("directoryThreshold");
            String rootDirectory = map.get("rootDirectory");
            String device = map.get("device");
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.DIRECTORY_ID.toString(), directoryId);
            formattedMap.put(AuditParamsNames.DIRECTORY_NAME.toString(), this.getCustomName(directoryName));
            formattedMap.put(AuditParamsNames.DIRECTORY_SIZE.toString(), this.getCustomName(directorySize));
            formattedMap.put(AuditParamsNames.DIRECTORY_THRESHOLD.toString(), this.getCustomName(directoryThreshold));
            formattedMap.put(AuditParamsNames.ROOT_DIRECTORY.toString(), this.getCustomName(rootDirectory));
            formattedMap.put(AuditParamsNames.DEVICE_NAME.toString(), this.getCustomName(device));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

