/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;

public class CalendarShareFormatter
extends Formatter {
    private static final Logger log = LoggerFactory.getLogger(CalendarShareFormatter.class);
    private final String shareIdKey = "shareId";
    private final String ownerIdKey = "ownerId";
    private final String shareUserIdKey = "shareUserId";
    private final String isGroupKey = "isGroup";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROTECTION_ID.toString(), map.get("shareId"));
            formattedMap.put(AuditParamsNames.CALENDAR_OWNER.toString(), map.get("ownerId"));
            formattedMap.put(AuditParamsNames.PROTECTION_NAME.toString(), map.get("shareUserId"));
            formattedMap.put(AuditParamsNames.PROTECTION_IS_GROUP.toString(), this.translateBooleanValue(map.get("isGroup"), LocaleContextHolder.getLocale()));
            return formattedMap;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

