/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.object.ActivityDef;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.util.ServiceFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public class UploadFileFromProcessFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(UploadFileFromProcessFormatter.class);
    private final String processIdKey = "processId";
    private final String activityIdKey = "activityId";
    private final String documentClassIdKey = "documentClassId";
    private final String descriptionIdKey = "description";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String processId = map.get("processId");
            String activityId = map.get("activityId");
            String documentClassId = map.get("documentClassId");
            ActivityDef activityDef = new ActivityDef(processId, activityId);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), activityDef.getProcessName());
            formattedMap.put(AuditParamsNames.ACTIVITY_NAME.toString(), activityDef.getActivityName());
            DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
            DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)Long.valueOf(documentClassId));
            if (documentClass != null) {
                formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.toString(), documentClass.getName());
            } else {
                formattedMap.put(AuditParamsNames.DOC_CLASS_ID.toString(), documentClassId);
            }
            formattedMap.put(AuditParamsNames.UPLOADED_FILE_DESCR.toString(), map.get("description"));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

