/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.scheduledTasks;

import com.plusmpm.database.dbspecific.NativeDatabase;
import com.plusmpm.database.dbspecific.Oracle10g;
import com.plusmpm.util.scheduledTasks.AbstractAdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.AdvancedTask;
import com.plusmpm.util.scheduledTasks.annotation.TaskParam;
import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.transaction.TransactionManagerFactory;
import com.suncode.pwfl.util.ComponentFactory;
import com.suncode.pwfl.util.QueryExecutor;
import org.apache.commons.lang.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class AuditParamRemover
extends AbstractAdvancedTask {
    private QueryExecutor queryExecutor = ComponentFactory.getQueryExecutor();
    private volatile double progress = 0.0;

    @AdvancedTask(name="AUDIT_SCHEDULED_TASK_REMOVE_PARAMS", description="AUDIT_SCHEDULED_TASK_REMOVE_PARAMS_DESCR", cancelable=false, translator=AdvancedTask.Translator.I18N)
    public void removeParamsByName(final @TaskParam(name="AUDIT_SCHEDULED_TASK_PARAM_REMOVE_PARAMS", description="AUDIT_SCHEDULED_TASK_PARAM_REMOVE_PARAMS_DESCR") String name) {
        this.inTransaction(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                AuditParamRemover.this.doRemove(name);
            }
        });
    }

    protected void doRemove(String name) {
        String regexp = name + "=[^.]*?" + "@AUDIT_PARAM@";
        DetachedCriteria criteria = DetachedCriteria.forClass(Audit.class).setProjection(null).setResultTransformer(Criteria.ROOT_ENTITY);
        if (!(NativeDatabase.getImplementation() instanceof Oracle10g)) {
            criteria.add((Criterion)Restrictions.like((String)"auditParams", (Object)("%" + name + "%")));
        }
        Session session = this.queryExecutor.getSession();
        long started = System.currentTimeMillis();
        taskLog.info((Object)"Task started...");
        long total = (Long)criteria.getExecutableCriteria(session).setProjection(Projections.rowCount()).uniqueResult();
        taskLog.info((Object)("Total audits to process: " + total));
        ScrollableResults results = criteria.getExecutableCriteria(session).setFetchSize(1000).setCacheMode(CacheMode.IGNORE).setProjection(null).setResultTransformer(Criteria.ROOT_ENTITY).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        int batchSize = 1000;
        while (results.next()) {
            Audit audit = (Audit)results.get(0);
            if (audit == null || StringUtils.isEmpty((String)audit.getAuditParams())) continue;
            String newAuditParams = audit.getAuditParams().replaceAll(regexp, "");
            if (!newAuditParams.equals(audit.getAuditParams())) {
                audit.setAuditParams(newAuditParams);
            }
            if (++count % batchSize == 0) {
                taskLog.info((Object)("Flushing changes after " + count + "/" + total + " audits..."));
                session.flush();
                session.clear();
                if (Thread.interrupted()) {
                    throw new RuntimeException("Task canceled");
                }
            }
            this.progress = (double)count / (double)total;
        }
        long elapsed = System.currentTimeMillis() - started;
        taskLog.info((Object)("Done in " + elapsed + " [ms]"));
    }

    private void inTransaction(TransactionCallbackWithoutResult callback) {
        TransactionTemplate tx = new TransactionTemplate(TransactionManagerFactory.getHibernateTransactionManager());
        tx.execute((TransactionCallback)callback);
    }

    public Double getProgress() {
        return this.progress;
    }
}

