/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.filter;

import com.suncode.pwfl.administration.user.UserInfo;
import com.suncode.pwfl.administration.user.UserInfoCache;
import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.audit.filter.AuditFilter;
import com.suncode.pwfl.audit.request.AuditCreator;
import com.suncode.pwfl.audit.request.RequestParamsAnalyzer;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.audit.util.AuditUrls;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AuditFilter
implements Filter {
    public static Logger log = Logger.getLogger(AuditFilter.class);
    private static Pattern actionPattern;
    private static Pattern restPattern;
    private static Pattern customServletPattern;
    private final String DEFAULT_URL = "NONE";
    private final String XHR_HEADER = "XMLHttpRequest";

    public void init(FilterConfig filterConfig) throws ServletException {
        actionPattern = Pattern.compile("^/(.*)(.do)$");
        restPattern = Pattern.compile("api/(.+?)\\z");
        customServletPattern = Pattern.compile("/(.+?)(.customServlet)$");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        AuditCreator auditCreator = new AuditCreator();
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        AuditUrls auditUrl = AuditUrls.getByUrl((String)this.getAuditUrlName(request.getServletPath(), request.getRequestURI()));
        Audit urlAudit = auditCreator.createAudit(request, auditUrl);
        if (urlAudit != null) {
            this.processUrlAudit(servletResponse, chain, request, urlAudit);
        } else {
            this.processManualAudit(request, servletResponse, chain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUrlAudit(ServletResponse servletResponse, FilterChain chain, HttpServletRequest auditRequest, Audit urlAudit) throws IOException, ServletException {
        boolean auditStopped = false;
        urlAudit.setAuditParams(this.getAuditParamsString(auditRequest));
        urlAudit.start();
        try {
            chain.doFilter((ServletRequest)auditRequest, servletResponse);
            urlAudit.stop();
            auditStopped = true;
            urlAudit.setAuditSuccess(this.buildAuditSuccess(auditRequest));
            this.addExtraParam(urlAudit, this.buildAuditExtraParam(auditRequest));
            this.verifyAuditType(urlAudit, auditRequest);
        }
        finally {
            if (!auditStopped) {
                urlAudit.stop();
                urlAudit.setAuditSuccess(false);
            }
            try {
                if (this.shouldLogAudit(urlAudit, (HttpServletResponse)servletResponse)) {
                    urlAudit.log();
                }
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void destroy() {
    }

    private String getAuditUrlName(String servletPath, String requestUri) {
        Matcher actionMatcher = actionPattern.matcher(servletPath);
        if (actionMatcher.matches()) {
            return actionMatcher.group(1);
        }
        Matcher restMatcher = restPattern.matcher(requestUri);
        if (restMatcher.find()) {
            return this.formatRestAuditUrl(restMatcher.group(1));
        }
        Matcher customServletMatcher = customServletPattern.matcher(servletPath);
        if (customServletMatcher.find()) {
            return customServletMatcher.group(1);
        }
        return "NONE";
    }

    private String formatRestAuditUrl(String auditUrl) {
        String formattedAuditUrl = auditUrl.replaceAll("/(\\d)*\\z", "");
        formattedAuditUrl = formattedAuditUrl.replaceAll("com.suncode.plugin-(.+?)/", "");
        formattedAuditUrl = formattedAuditUrl.replaceAll("/com.suncode.plugin-(.+?)\\z", "");
        return formattedAuditUrl;
    }

    private String getAuditParamsString(HttpServletRequest request) {
        String auditParamsString = "";
        try {
            RequestParamsAnalyzer analyzer = new RequestParamsAnalyzer();
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                auditParamsString = analyzer.getApplicationEnctypeParamsString(request);
            } else {
                log.error((Object)"Request is of multipart type with automatic audits, skipping request parameters read.");
            }
            auditParamsString = analyzer.format(auditParamsString);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return auditParamsString;
    }

    private boolean buildAuditSuccess(HttpServletRequest auditRequest) {
        Object auditSuccessAttr = auditRequest.getAttribute("auditSuccess");
        return auditSuccessAttr != null ? (Boolean)auditSuccessAttr : false;
    }

    private String buildAuditExtraParam(HttpServletRequest auditRequest) {
        Object auditExtraParam = auditRequest.getAttribute("auditExtraParam");
        return auditExtraParam != null ? (String)auditExtraParam : "";
    }

    private void addExtraParam(Audit audit, String extraParam) {
        if (StringUtils.isBlank((CharSequence)audit.getAuditParams())) {
            audit.setAuditParams(extraParam);
        } else {
            audit.setAuditParams(audit.getAuditParams().concat("@AUDIT_PARAM@").concat(extraParam));
        }
    }

    private void verifyAuditType(Audit audit, HttpServletRequest request) {
        try {
            switch (1.$SwitchMap$com$suncode$pwfl$audit$util$AuditTypes[AuditTypes.valueOf((String)audit.getAuditType()).ordinal()]) {
                case 1: {
                    String activitiesSearch = (String)request.getAttribute("activitiesSearch");
                    if (activitiesSearch == null || !activitiesSearch.equalsIgnoreCase("TRUE")) break;
                    audit.changeAuditType(AuditTypes.AUDIT_SEARCH_ACTIVITIES);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean shouldLogAudit(Audit audit, HttpServletResponse response) {
        if (this.isAutoLogoutAudit(audit)) {
            return response.getStatus() == 401;
        }
        return true;
    }

    private boolean isAutoLogoutAudit(Audit audit) {
        return AuditTypes.getByName((String)audit.getAuditType()).equals((Object)AuditTypes.AUDIT_AUTO_LOG_OUT);
    }

    private void processManualAudit(HttpServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Long started = new Date().getTime();
        chain.doFilter((ServletRequest)request, response);
        Long stopped = new Date().getTime();
        this.getAudits(request).forEach(auditWrapper -> {
            Audit audit = Audit.create((AuditWrapper)auditWrapper);
            audit.setAuditStarted(started.longValue());
            audit.setAuditStopped(stopped.longValue());
            audit.setAuditDuration(stopped - started);
            String sessionUserId = null;
            if (request.getSession(false) != null) {
                sessionUserId = (String)request.getSession().getAttribute("username");
            }
            String userId = StringUtils.isBlank(sessionUserId) ? audit.getUserId() : sessionUserId;
            String resolvedUserId = (String)StringUtils.defaultIfEmpty((CharSequence)userId, (CharSequence)ManualAuditBuilder.UNKNOWN);
            audit.setUserId(resolvedUserId);
            UserInfo userInfo = resolvedUserId.equals(ManualAuditBuilder.UNKNOWN) ? null : UserInfoCache.get().get(resolvedUserId);
            boolean isAnonymousUser = userInfo != null && userInfo.isAnonymous();
            String resolvedIpAddress = isAnonymousUser ? ManualAuditBuilder.UNKNOWN : (String)StringUtils.defaultIfEmpty((CharSequence)request.getRemoteAddr(), (CharSequence)ManualAuditBuilder.UNKNOWN);
            audit.setIpAddress(resolvedIpAddress);
            audit.setThreadId(Thread.currentThread().getName());
            try {
                audit.log();
            }
            catch (Exception ex) {
                log.error((Object)("Problem with logging audit " + audit.getAuditType()), (Throwable)ex);
            }
        });
    }

    private List<AuditWrapper> getAudits(HttpServletRequest request) {
        ArrayList<AuditWrapper> audits = new ArrayList<AuditWrapper>();
        AuditWrapper audit = this.getSingleAudit(request);
        if (audit != null) {
            audits.add(this.getSingleAudit(request));
        }
        audits.addAll(this.getMultipleAudits(request));
        return audits;
    }

    private AuditWrapper getSingleAudit(HttpServletRequest request) {
        Object auditWrapperAttribute = request.getAttribute("audit");
        if (auditWrapperAttribute != null && auditWrapperAttribute instanceof AuditWrapper) {
            return (AuditWrapper)auditWrapperAttribute;
        }
        return null;
    }

    private List<AuditWrapper> getMultipleAudits(HttpServletRequest request) {
        ArrayList<AuditWrapper> audits = new ArrayList<AuditWrapper>();
        Object auditsWrapperAttribute = request.getAttribute("audits");
        if (auditsWrapperAttribute != null && auditsWrapperAttribute instanceof List) {
            ((List)auditsWrapperAttribute).forEach(auditWrapperAttribute -> {
                if (auditWrapperAttribute != null && auditWrapperAttribute instanceof AuditWrapper) {
                    audits.add((AuditWrapper)auditWrapperAttribute);
                }
            });
        }
        return audits;
    }
}

