/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.formatter.UpdateDocClassFormatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddDocClassFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddDocClassFormatter.class);
    private final String docClassIdKey = "docClassId";
    private final String docclassNameKey = "docclassName";
    private final String docclassDescrKey = "docclassDescr";
    private final String expireDocumentTypeKey = "expireDocumentType";
    private final String docclassExpiretionKey = "docclassExpiretion";
    private final String docclassExpiretion2Key = "docclassExpiretion2";
    private final String docclassExpiretion3Key = "docclassExpiretion3";
    private final String directoryNameKey = "directoryName";
    private final String docclassIndexingKey = "docclassIndexing";
    private final String docclassEncodingKey = "docclassEncoding";
    private final String cipherAlgorithmKey = "cipherAlgorithm";
    private final String keyLenghtKey = "keyLenght";
    private final String docclassComperssingKey = "docclassComperssing";
    private final String maxFileSizeKey = "maxFileSize";
    private final String iconKey = "icon";
    private final String iconColorKey = "iconColor";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put("docClassId", map.get("docClassId"));
            formattedMap.put("docclassName", map.get("docclassName"));
            formattedMap.put("docclassDescr", map.get("docclassDescr"));
            formattedMap.put(AuditParamsNames.MAXFILESIZE.toString(), this.getNumericValue(map.get("maxFileSize")));
            formattedMap.put("expireDocumentType", UpdateDocClassFormatter.translateExpirationTypeName((String)map.get("expireDocumentType")));
            formattedMap.put("docclassExpiretion", map.get("docclassExpiretion"));
            formattedMap.put("docclassExpiretion2", map.get("docclassExpiretion2"));
            formattedMap.put("docclassExpiretion3", map.get("docclassExpiretion3"));
            formattedMap.put(AuditParamsNames.DOC_CLASS_DIRECTORY_NAME.toString(), map.get("directoryName"));
            formattedMap.put("docclassIndexing", this.translateBooleanValue(map.get("docclassIndexing"), locale));
            String docClassEncoding = map.get("docclassEncoding");
            formattedMap.put("docclassEncoding", this.translateBooleanValue(docClassEncoding, locale));
            String cipherAlgorithm = map.get("cipherAlgorithm");
            if (!Boolean.valueOf(docClassEncoding).booleanValue()) {
                cipherAlgorithm = "";
            }
            formattedMap.put("cipherAlgorithm", cipherAlgorithm);
            formattedMap.put("keyLenght", this.getNumericValue(map.get("keyLenght")));
            formattedMap.put("docclassComperssing", this.translateBooleanValue(map.get("docclassComperssing"), locale));
            formattedMap.put(AuditParamsNames.ICON.name(), map.get("icon"));
            formattedMap.put(AuditParamsNames.ICON_COLOR.name(), map.get("iconColor"));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getNumericValue(String numericValue) {
        return StringUtils.isBlank((String)numericValue) || numericValue.equals("0") ? "" : numericValue;
    }
}

