/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.service;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.AuditCoreService;
import com.suncode.pwfl.audit.AuditDtoCore;
import com.suncode.pwfl.audit.AuditExecutor;
import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.FilterConfigCore;
import com.suncode.pwfl.audit.dao.AuditDao;
import com.suncode.pwfl.audit.object.AuditFetchResult;
import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.service.AuditService;
import com.suncode.pwfl.search.CountedResult;
import com.suncode.pwfl.search.SortDirection;
import com.suncode.pwfl.util.EditableServiceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="auditService")
public class AuditServiceImpl
extends EditableServiceImpl<Audit, Long, AuditDao>
implements AuditService,
AuditExecutor,
AuditCoreService {
    @Autowired
    public void setDao(AuditDao dao) {
        this.dao = dao;
    }

    @Override
    @Transactional
    public AuditFetchResult getAudits(String orderBy, boolean bAsc, int iOffset, int iLimit, FilterConfig filterConfig) {
        return ((AuditDao)this.dao).getAudits(orderBy, bAsc, iOffset, iLimit, filterConfig);
    }

    @Override
    @Transactional
    public Audit getAudit(Long lAuditId) {
        return ((AuditDao)this.dao).getAudit(lAuditId);
    }

    @Override
    @Transactional
    public HashMap<String, Long> getAvgDurations() {
        return ((AuditDao)this.dao).getAvgDurations();
    }

    @Override
    @Transactional
    public int deleteAudits(Date date) {
        return ((AuditDao)this.dao).deleteAudits(date);
    }

    @Override
    @Transactional
    public int deleteAudits(Date dateFrom, Date dateTo) {
        return ((AuditDao)this.dao).deleteAudits(dateFrom, dateTo);
    }

    @Override
    @Transactional
    public int deleteAudits(String userId) {
        return ((AuditDao)this.dao).deleteAudits(userId);
    }

    public void log(AuditWrapper wrapper) {
        Audit.create(wrapper).log();
    }

    @Transactional
    public CountedResult<AuditDtoCore> getAudits(FilterConfigCore filterConfigCore, Integer start, Integer limit, String sortBy, SortDirection sortDirection) {
        FilterConfig filterConfig = FilterConfig.fromFilterConfigCore(filterConfigCore);
        AuditFetchResult auditFetchResult = this.getAudits(sortBy, sortDirection == SortDirection.ASC, (int)start, limit, filterConfig);
        List auditDtoCores = auditFetchResult.getAudits().stream().map(Audit::toAuditDtoCore).collect(Collectors.toList());
        return new CountedResult(auditFetchResult.getCount(), auditDtoCores);
    }
}

