/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.plusmpm.util.XpdlPackageManager;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.xpdl.elements.Package;
import org.enhydra.shark.xpdl.elements.WorkflowProcess;

public class CreateProcessFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(CreateProcessFormatter.class);
    private final String processDefIdKey = "processId";
    private final String packageIdKey = "processPackageId";
    private final String procesName = "procesName";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        if (StringUtils.isBlank((CharSequence)map.get("processId"))) {
            return (LinkedHashMap)map;
        }
        Package pack = null;
        WorkflowProcess wp = null;
        try {
            String processDefId = map.get("processId");
            String packageId = map.get("processPackageId");
            pack = XpdlPackageManager.getInstance().getPackage(packageId);
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            if (pack != null) {
                wp = pack.getWorkflowProcess(processDefId);
                if (map.containsKey("procesName")) {
                    formattedMap.put(AuditParamsNames.PROCESS_NAME.toString(), map.get("procesName"));
                }
                formattedMap.put(AuditParamsNames.PROCESS_TYPE.toString(), wp.getName());
                formattedMap.put(AuditParamsNames.PACKAGE_NAME.toString(), pack.getName());
            }
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }
}

