/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.util;

import com.suncode.pwfl.audit.Audit;
import com.suncode.pwfl.audit.object.ExportConfig;
import com.suncode.pwfl.audit.util.AuditExtractor;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.audit.util.PdfTableHeaders;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class ExcelAuditExtractor
extends AuditExtractor {
    private int maxColumnNum;
    private List<Audit> audits;
    private OutputStream outputStream;
    private SXSSFWorkbook workbook;
    private SXSSFSheet sheet;
    private SXSSFRow xlsRow;
    private SXSSFCell cell;
    private int rowNum;
    private int colNum;
    private SimpleDateFormat dateFormat;

    public ExcelAuditExtractor(ExportConfig config) {
        super(config);
        this.audits = config.getAudits();
        this.outputStream = config.getOutputStream();
        this.rowNum = 0;
        this.colNum = 0;
        this.maxColumnNum = 0;
    }

    public void extract() throws Exception {
        this.workbook = new SXSSFWorkbook();
        this.sheet = this.workbook.createSheet(this.getTextTranslation("Elementy_audytowe_systemu_Plus_Workflow"));
        this.sheet.trackAllColumnsForAutoSizing();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.addHeaders();
        this.fillSheet();
        IntStream.range(0, this.maxColumnNum + 1).forEach(column -> this.sheet.autoSizeColumn(column));
        this.workbook.write(this.outputStream);
        this.workbook.dispose();
    }

    private void addHeaders() {
        PdfTableHeaders[] pdfTableHeaders = PdfTableHeaders.values();
        CellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setFillPattern(FillPatternType.FINE_DOTS);
        headerStyle.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.BLUE_GREY.getIndex());
        Font bold = this.workbook.createFont();
        bold.setBold(true);
        bold.setColor(HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        headerStyle.setFont(bold);
        this.xlsRow = this.sheet.createRow(this.rowNum++);
        this.addStyledCell("Lp.", headerStyle);
        for (int i = 0; i < pdfTableHeaders.length; ++i) {
            this.addStyledCell(this.getTextTranslation(pdfTableHeaders[i].toString()), headerStyle);
        }
    }

    private void fillSheet() {
        CellStyle successStyle = this.workbook.createCellStyle();
        Font successFont = this.workbook.createFont();
        successStyle.setFont(successFont);
        CellStyle errorStyle = this.workbook.createCellStyle();
        Font redFont = this.workbook.createFont();
        redFont.setColor(HSSFColor.HSSFColorPredefined.RED.getIndex());
        errorStyle.setFont(redFont);
        for (Audit audit : this.audits) {
            this.xlsRow = this.sheet.createRow(this.rowNum++);
            this.colNum = 0;
            CellStyle currentStyle = audit.isAuditSuccess() ? successStyle : errorStyle;
            this.addStyledCell(String.valueOf(this.rowNum - 1), currentStyle);
            this.addStyledCell(audit.getUserId(), successStyle);
            this.addStyledCell(this.getAuditTypeTranslation(audit.getAuditType()), currentStyle);
            this.addStyledCell(this.dateFormat.format(new Date(audit.getAuditStarted())), currentStyle);
            this.addStyledCell(this.dateFormat.format(new Date(audit.getAuditStopped())), currentStyle);
            this.addStyledCell(AuditTools.getDurationValue((long)audit.getAuditDuration()), currentStyle);
            if (this.colNum <= this.maxColumnNum) continue;
            this.maxColumnNum = this.colNum;
        }
    }

    private void addStyledCell(String cellValue, CellStyle cellStyle) {
        this.addCell(cellValue);
        this.cell.setCellStyle(cellStyle);
    }

    private void addCell(String cellValue) {
        cellValue = (String)StringUtils.defaultIfEmpty((CharSequence)cellValue, (CharSequence)"");
        this.cell = this.xlsRow.createCell(this.colNum++);
        this.cell.setCellValue((RichTextString)new XSSFRichTextString(cellValue));
    }
}

