/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.context.i18n.LocaleContextHolder;

public class AddSystemProtectionFormatter
extends Formatter {
    public static Logger log = Logger.getLogger(AddSystemProtectionFormatter.class);
    private final String userIdKey = "userName";
    private final String isGroupKey = "isGroup";
    private final String moduleIdKey = "systemModule";

    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        try {
            String userId = map.get("userName");
            String isGroup = map.get("isGroup");
            String moduleId = map.get("systemModule");
            if (StringUtils.isBlank((String)isGroup)) {
                isGroup = "FALSE";
            }
            Locale locale = LocaleContextHolder.getLocale();
            LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
            formattedMap.put(AuditParamsNames.USER_NAME.toString(), AuditTools.getUserRealName((String)userId));
            formattedMap.put(AuditParamsNames.IS_GROUP.toString(), MessageHelper.getOptionalMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toUpperCase()), (Locale)locale, (Object[])new Object[0]));
            formattedMap.put(AuditParamsNames.SYSTEM_MODULE_NAME.toString(), this.getTranslatedModuleName(moduleId));
            return formattedMap;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return new LinkedHashMap<String, String>();
        }
    }

    private String getTranslatedModuleName(String moduleName) {
        switch (moduleName) {
            case "System": {
                return MessageHelper.getMessage((String)"System");
            }
            case "System.Admin": {
                return MessageHelper.getMessage((String)"Administracja");
            }
            case "System.Archive": {
                return MessageHelper.getMessage((String)"Archiwum");
            }
            case "System.Archive.DocClasses": {
                return MessageHelper.getMessage((String)"Klasy_dokumentow");
            }
            case "System.Archive.Links": {
                return MessageHelper.getMessage((String)"Zestawy_dokumentow");
            }
            case "System.Workflow": {
                return MessageHelper.getMessage((String)"Obieg_dokumentow");
            }
            case "System.Workflow.Processes.create": {
                return MessageHelper.getMessage((String)"Tworzenie_procesow");
            }
            case "System.Workflow.Tasks": {
                return MessageHelper.getMessage((String)"Zadania");
            }
            case "System.Workflow.Calendar": {
                return MessageHelper.getMessage((String)"Kalendarz");
            }
            case "System.Workflow.Processes.view": {
                return MessageHelper.getMessage((String)"Wyszukiwanie_procesow");
            }
            case "System.Workflow.Processes.stats": {
                return MessageHelper.getMessage((String)"Statystyki_procesow");
            }
            case "System.Workflow.Processes.history": {
                return MessageHelper.getMessage((String)"History");
            }
            case "System.Reports": {
                return MessageHelper.getMessage((String)"Raporty");
            }
            case "System.UserAccount": {
                return MessageHelper.getMessage((String)"Konto_uzytkownika");
            }
            case "system.plugins": {
                return MessageHelper.getMessage((String)"Moduly");
            }
            case "System.Views": {
                return MessageHelper.getMessage((String)"Widoki");
            }
        }
        return moduleName;
    }
}

