/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.formatter;

import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import com.suncode.pwfl.archive.DocumentClassIndexFinder;
import com.suncode.pwfl.archive.DocumentClassService;
import com.suncode.pwfl.audit.formatter.Formatter;
import com.suncode.pwfl.audit.util.AuditParamsNames;
import com.suncode.pwfl.audit.util.AuditTools;
import com.suncode.pwfl.i18n.MessageHelper;
import com.suncode.pwfl.translation.configElements.TranslatedFieldType;
import com.suncode.pwfl.util.ServiceFactory;
import com.suncode.pwfl.util.SpringContext;
import com.suncode.pwfl.workflow.constant.DocumentAuthorizationConditionType;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.StringUtils;

public class AddDocClassProtectionConditionFormatter
extends Formatter {
    private final String docClassIdKey = "docClassId";
    private final String userIdKey = "userId";
    private final String isGroupKey = "isGroup";
    private final String conditionTypeKey = "conditionType";
    private final String docClassIndexIdKey = "docClassIndexId";
    private final String operatorKey = "operator";
    private final String isNegationKey = "isNegation";
    private final String valueKey = "value";

    @Override
    public LinkedHashMap<String, String> format(HashMap<String, String> map) {
        Long docClassId = Long.valueOf(map.get("docClassId"));
        String userId = map.get("userId");
        Boolean isGroup = Boolean.valueOf(map.get("isGroup"));
        DocumentAuthorizationConditionType conditionType = DocumentAuthorizationConditionType.valueOf((String)map.get("conditionType"));
        String docClassIndexIdString = map.get("docClassIndexId");
        Long docClassIndexId = StringUtils.isNotBlank((CharSequence)docClassIndexIdString) ? Long.valueOf(docClassIndexIdString) : -1L;
        String operator = map.get("operator");
        Boolean isNegation = Boolean.valueOf(map.get("isNegation"));
        String value = map.get("value");
        LinkedHashMap<String, String> formattedMap = new LinkedHashMap<String, String>();
        DocumentClassService documentClassService = ServiceFactory.getDocumentClassService();
        DocumentClass documentClass = (DocumentClass)documentClassService.get((Serializable)docClassId);
        if (documentClass != null) {
            formattedMap.put(AuditParamsNames.DOC_CLASS_NAME.name(), documentClassService.getDocumentClassTranslation(docClassId, TranslatedFieldType.NAME));
        } else {
            formattedMap.put(AuditParamsNames.DOC_CLASS_ID.name(), docClassId.toString());
        }
        formattedMap.put(AuditParamsNames.USER_NAME.name(), AuditTools.getUserRealName(userId));
        formattedMap.put(AuditParamsNames.IS_GROUP.name(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(isGroup.toString().toUpperCase())));
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_TYPE.name(), MessageHelper.getMessage((String)conditionType.getValue()));
        DocumentClassIndexFinder documentClassIndexFinder = (DocumentClassIndexFinder)SpringContext.getBean(DocumentClassIndexFinder.class);
        DocumentClassIndex documentClassIndex = (DocumentClassIndex)documentClassIndexFinder.get((Serializable)docClassIndexId);
        if (documentClassIndex != null) {
            formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_NAME.name(), documentClassService.getDocumentClassIndexTranslation(docClassIndexId, TranslatedFieldType.NAME));
        } else {
            formattedMap.put(AuditParamsNames.DOC_CLASS_INDEX_ID.name(), docClassIndexIdString);
        }
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_IS_NEGATION.name(), MessageHelper.getMessage((String)"AUDIT_PARAM_VALUE_".concat(isNegation.toString().toUpperCase())));
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_OPERATOR.name(), operator);
        formattedMap.put(AuditParamsNames.CONDITION_RIGHT_VALUE.name(), value);
        return formattedMap;
    }
}

