( function( Ext ) {
    Ext.define( 'Suncode.audit.view.AuditGrid', {
        extend: 'Ext.grid.Panel',
        requires: [ 'Suncode.audit.store.AuditStore', 'Suncode.audit.view.DetailsWindow', 'Suncode.audit.view.ExportWindow' ],
        alias: 'widget.audit-grid',
        autoScroll: true,
        columnLines: true,
        frame: true,
        columns: [ {
            text: '',
            dataIndex: 'auditId',
            hidden: true,
            hideable: false
        }, {
            text: PW.t('user'),
            dataIndex: 'userId',
            align: 'center',
            width: 150
        }, {
            text: PW.t('ipAddress'),
            dataIndex: 'ipAddress',
            align: 'center',
            hidden: true,
            width: 120
        }, {
            text: PW.t('threadId'),
            dataIndex: 'threadId',
            align: 'center',
            hidden: true,
            width: 120
        }, {
            text: PW.t('name'),
            dataIndex: 'auditType',
            align: 'center',
            flex: 1,
            sortable: false
        }, {
            text: PW.t('startTime'),
            dataIndex: 'auditStarted',
            align: 'center',
            width: 170
        }, {
            text: PW.t('stopTime'),
            dataIndex: 'auditStopped',
            align: 'center',
            width: 170
        }, {
            text: PW.t('duration'),
            dataIndex: 'auditDuration',
            align: 'center',
            width: 120
        }, {
            text: PW.t('success'),
            dataIndex: 'auditSuccess',
            align: 'center',
            width: 80,
            renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                if ( value ) {
                    return '<div class="audit-grid-icon dvnt-icon-check-symbol dvnt-green-icon"></div>';
                } else {
                    return '<div class="audit-grid-icon dvnt-icon-x-symbol dvnt-red-icon"></div>';
                }
            }
        }, {
            text: PW.t('details'),
            dataIndex: 'auditDetails',
            align: 'center',
            width: 80,
            sortable: false,
            renderer: function( value, metaData, record, rowIndex, colIndex, store ) {
                return '<div class="audit-grid-icon dvnt-icon-settings dvnt-gray-icon"></div>';
            }
        } ],
        viewConfig: {
            getRowClass: function( record, index, rowParams, store ) {
                return record.get( 'auditSuccess' ) ? '' : 'x-audit-failed-row';
            },
            loadingText: PW.t('loading'),
            emptyText: PW.t('noAudits')
        },
        selModel: {
            model: 'SIMPLE',
            listeners: {
                beforeselect: function( sm, record, index, eOpts ) {
                    return false;
                }
            }
        },
        tbar: {
            items: [ '->', {
                xtype: 'button',
                text: 'PDF',
                iconCls: 'dvnt-icon-pdf',
                handler: function( button ) {
                    var auditGrid = button.ownerCt.ownerCt;
                    var auditFilters = auditGrid.up( 'audit-panel' ).down( 'audit-filters' );

                    var exportWindow = Ext.create( 'Suncode.audit.view.ExportWindow', {
                        exportType: 'PDF',
                        generateButtonIcon: 'style/img/fam/page_white_acrobat.png',
                        sortInfo: auditGrid.getStore().sorters.items.first(),
                        filterConfig: auditFilters.buildFilterConfig()
                    } );
                    exportWindow.show();
                }
            }, {
                xtype: 'button',
                text: 'EXCEL',
                iconCls: 'dvnt-icon-excel',
                handler: function( button ) {
                    var auditGrid = button.ownerCt.ownerCt;
                    var auditFilters = auditGrid.up( 'audit-panel' ).down( 'audit-filters' );

                    var exportWindow = Ext.create( 'Suncode.audit.view.ExportWindow', {
                        exportType: 'XLS',
                        generateButtonIcon: 'style/img/fam/page_excel.png',
                        sortInfo: auditGrid.getStore().sorters.items.first(),
                        filterConfig: auditFilters.buildFilterConfig(),
                        totalCount: auditGrid.store.totalCount
                    } );
                    exportWindow.show();
                }
            } ]
        },
        listeners: {
            afterrender: function (grid) {
                var store = grid.getStore();
                store.getProxy().extraParams = grid.up('audit-panel').down('audit-filters').buildFilterConfig();
                store.loadPage(1);
            },
            cellclick: function( grid, td, cellIndex, record, tr, rowIndex, e, eOpts ) {
                var cols = grid.headerCt.getGridColumns();
                var col = cols[cellIndex];
                if ( col.dataIndex != 'auditDetails' ) {
                    return;
                }

                Ext.Ajax.request( {
                    url: 'com.suncode.pwfl.audit.servlet.GetAuditDetails.customServlet',
                    method: 'GET',
                    params: {
                        auditId: record.get( 'auditId' )
                    },
                    success: function( response, opts ) {
                        var responseTxt = response.responseText;
                        var responseJson = Ext.JSON.decode( responseTxt );

                        if ( !responseJson.success ) {
                            Ext.Msg.show( {
                                title: PW.t('warn'),
                                msg: PW.t('getDetailsError'),
                                buttons: Ext.Msg.OK,
                                icon: Ext.Msg.ERROR
                            } );
                            return;
                        }

                        var detailsWin = Ext.create( 'Suncode.audit.view.DetailsWindow', {
                            auditDetails: responseJson.auditDetails
                        } );
                        detailsWin.show();
                    },
                    failure: function( response, opts ) {
                        Ext.Msg.show( {
                            title: PW.t('warn'),
                            msg: PW.t('getDetailsError'),
                            buttons: Ext.Msg.OK,
                            icon: Ext.Msg.ERROR
                        } );
                    }
                } );
            },
            columnshow: function( ct, column, eOpts ) {
                column.up( 'audit-grid' ).handleFilterVisibility( column.dataIndex, true );
            },
            columnhide: function( ct, column, eOpts ) {
                column.up( 'audit-grid' ).handleFilterVisibility( column.dataIndex, false );
            }
        },
        initComponent: function() {
            var store = Ext.create( 'Suncode.audit.store.AuditStore', {
                storeId: 'auditStore'
            } );

            this.store = store;
            this.bbar = Ext.create( 'Ext.toolbar.Paging', {
                pageSize: 25,
                inputItemWidth: 40,
                afterPageText: PW.t('outOf') + ' {0}',
                beforePageText: PW.t('page'),
                firstText: PW.t('firstPage'),
                lastText: PW.t('lastPage'),
                nextText: PW.t('nextPage'),
                prevText: PW.t('previousPage'),
                refreshText: PW.t('refresh'),
                store: store,
                displayInfo: true,
                displayMsg: PW.t('audits') + ' {0} - {1} ' + PW.t('outOf') + ' {2}',
                emptyMsg: PW.t('noAudits')
            } );

            this.callParent();
        },
        handleFilterVisibility: function( filterFor, showFilter ) {
            if ( filterFor != 'auditDetails' ) {
                var filterItems = this.up( 'audit-panel' ).down( 'audit-filters' ).query( 'component[filterFor=' + filterFor + ']' );

                Ext.each( filterItems, function( item, index, items ) {
                    if ( showFilter ) {
                        item.show();
                    } else {
                        item.hide();
                    }
                } );
            }
        }
    } );
}( this.Ext4 ) );