/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.util;

import com.suncode.pwfl.audit.object.FilterConfig;
import com.suncode.pwfl.audit.util.AuditTypes;
import com.suncode.pwfl.translation.TranslationSupport;
import com.suncode.pwfl.translation.Translator;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.client.wfservice.UserGroupAdministration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AuditTools {
    public static Logger log = Logger.getLogger(AuditTools.class);

    public static String getDurationValue(long duration) {
        try {
            long days = TimeUnit.MILLISECONDS.toDays(duration);
            long hours = TimeUnit.MILLISECONDS.toHours(duration) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(duration));
            long minutes = TimeUnit.MILLISECONDS.toMinutes(duration) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration));
            long seconds = TimeUnit.MILLISECONDS.toSeconds(duration) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration));
            long miliseconds = TimeUnit.MILLISECONDS.toMillis(duration) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(duration));
            DecimalFormat twoPlacesFormat = new DecimalFormat("00");
            DecimalFormat threePlacesFormat = new DecimalFormat("000");
            if (days > 0L) {
                return days + ":" + twoPlacesFormat.format(hours) + ":" + twoPlacesFormat.format(minutes) + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(miliseconds);
            }
            if (hours > 0L) {
                return hours + ":" + twoPlacesFormat.format(minutes) + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(miliseconds);
            }
            if (minutes > 0L) {
                return minutes + ":" + twoPlacesFormat.format(seconds) + "." + threePlacesFormat.format(miliseconds);
            }
            if (seconds > 0L) {
                return seconds + "." + threePlacesFormat.format(miliseconds);
            }
            if (miliseconds > 0L) {
                return "0." + threePlacesFormat.format(miliseconds);
            }
            return "< 0.001";
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return "0";
        }
    }

    public static String joinTabValue(String[] tab, String mark) {
        StringBuilder buf = new StringBuilder("");
        for (int i = 1; i < tab.length; ++i) {
            buf.append(tab[i]);
            if (i >= tab.length - 1) continue;
            buf.append(mark);
        }
        return buf.toString();
    }

    public static String getUserRealName(String userId) {
        UserGroupAdministration uga = null;
        try {
            uga = Shark.getInstance().getAdminInterface().getUserGroupAdministration();
            String realUserName = uga.getUserRealName(userId);
            return StringUtils.isNotBlank((String)realUserName) ? realUserName : userId;
        }
        catch (Exception e) {
            return userId;
        }
    }

    public static Document getXMLFromInputStream(InputStream inputStream) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = null;
        InputSource inputSource = null;
        try (InputStreamReader reader = null;){
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            reader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(reader);
            documentBuilderFactory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            return document;
        }
    }

    public static FilterConfig buildFilterConfig(HttpServletRequest request) throws ParseException {
        FilterConfig filterConfig = new FilterConfig();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String auditType = request.getParameter("auditType");
        String auditStartedFrom = request.getParameter("auditStartedFrom");
        String auditStartedTo = request.getParameter("auditStartedTo");
        String auditStoppedFrom = request.getParameter("auditStoppedFrom");
        String auditStoppedTo = request.getParameter("auditStoppedTo");
        String auditDurationFrom = request.getParameter("auditDurationFrom");
        String auditDurationTo = request.getParameter("auditDurationTo");
        String auditSuccess = request.getParameter("auditSuccess");
        filterConfig.setUserId(request.getParameter("userId"));
        filterConfig.setIpAddress(request.getParameter("ipAddress"));
        filterConfig.setThreadId(request.getParameter("threadId"));
        filterConfig.setAuditDetails(request.getParameter("auditDetails"));
        if (StringUtils.isNotBlank((String)auditType)) {
            String[] auditTypeSplit = auditType.split(";");
            filterConfig.setAuditTypes(AuditTools.buildAuditTypesList(auditTypeSplit));
        }
        if (StringUtils.isNotBlank((String)auditStartedFrom)) {
            filterConfig.setAuditStartedFrom(sdf.parse(auditStartedFrom).getTime());
        }
        if (StringUtils.isNotBlank((String)auditStartedTo)) {
            filterConfig.setAuditStartedTo(sdf.parse(auditStartedTo).getTime());
        }
        if (StringUtils.isNotBlank((String)auditStoppedFrom)) {
            filterConfig.setAuditStoppedFrom(sdf.parse(auditStoppedFrom).getTime());
        }
        if (StringUtils.isNotBlank((String)auditStoppedTo)) {
            filterConfig.setAuditStoppedTo(sdf.parse(auditStoppedTo).getTime());
        }
        if (StringUtils.isNotBlank((String)auditDurationFrom)) {
            filterConfig.setAuditDurationFrom(Long.parseLong(auditDurationFrom));
        }
        if (StringUtils.isNotBlank((String)auditDurationTo)) {
            filterConfig.setAuditDurationTo(Long.parseLong(auditDurationTo));
        }
        if (StringUtils.isNotBlank((String)auditSuccess) && auditSuccess.compareTo("AUDIT_ALL") != 0) {
            filterConfig.setAuditSuccess(Boolean.parseBoolean(auditSuccess));
        }
        return filterConfig;
    }

    private static List<String> buildAuditTypesList(String[] auditTypesTable) {
        ArrayList<String> auditTypes = new ArrayList<String>();
        for (String auditType : auditTypesTable) {
            auditTypes.add(auditType);
        }
        return auditTypes;
    }

    public static boolean isDefinedAudit(String auditType) {
        try {
            AuditTypes type = AuditTypes.valueOf((String)auditType);
            if (type.equals((Object)AuditTypes.AUDIT_DASHBOARD_LOADED)) {
                return false;
            }
            return !type.equals((Object)AuditTypes.AUDIT_GADGET_LOADING);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getParamTranslation(String paramName, List<Translator> translators) {
        String prefixedParam;
        String paramTranslation = TranslationSupport.getMessage((String)paramName, translators);
        if (paramTranslation.equals(paramName) && (prefixedParam = "AUDIT_PARAM_" + paramName.toUpperCase()).equals(paramTranslation = TranslationSupport.getMessageOrDefault((String)prefixedParam, (String)paramName, translators))) {
            return paramName;
        }
        return paramTranslation;
    }
}

