/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.web.ui;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.net.MediaType;
import com.suncode.pwfl.web.ui.Icon;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.springframework.util.Assert;

public class Base64Icon
implements Icon {
    private MediaType mediaType;
    private String src;

    public Base64Icon(String src, MediaType mediaType) {
        Assert.notNull((Object)src, (String)"[Assertion failed] - this argument is required; it must not be null");
        this.mediaType = mediaType != null ? mediaType.withoutParameters() : MediaType.ANY_IMAGE_TYPE;
        this.src = Base64.isBase64((String)src) ? src : Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)src));
    }

    @JsonProperty(value="icon")
    public String getDataUrl() {
        return "data:" + String.valueOf(this.mediaType.withoutParameters()) + ";base64," + this.src;
    }

    @Override
    public Icon.Type getType() {
        return Icon.Type.BASE64;
    }
}

