/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.security.extraverifiers;

import com.suncode.pwfl.security.extraverifiers.AuthenticationParameters;
import com.suncode.pwfl.security.extraverifiers.ExtraAuthVerifierValueProvider;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtraAuthVerifier {
    private static final Logger log = LoggerFactory.getLogger(ExtraAuthVerifier.class);
    private ExtraAuthVerifierValueProvider firstValueProvider;
    private ExtraAuthVerifierValueProvider secondValueProvider;
    private boolean ignoreCase;

    public boolean isValid(AuthenticationParameters authenticationParameters) {
        boolean valid;
        List<String> firstValues = this.firstValueProvider.getValuesToCompare(authenticationParameters);
        List<String> secondValues = this.secondValueProvider.getValuesToCompare(authenticationParameters);
        if (firstValues == null && secondValues == null) {
            log.warn("Both extra auth verifier values are null");
            return false;
        }
        if (firstValues == null || secondValues == null) {
            String first = StringUtils.join(firstValues, (char)',');
            String second = StringUtils.join(secondValues, (char)',');
            log.warn(String.format("One of extra auth verifier values is null. First value: %s , second value: %s", first, second));
            return false;
        }
        if (this.ignoreCase) {
            firstValues = firstValues.stream().map(String::toLowerCase).collect(Collectors.toList());
            secondValues = secondValues.stream().map(String::toLowerCase).collect(Collectors.toList());
        }
        if (!(valid = CollectionUtils.isEqualCollection(firstValues, secondValues))) {
            String first = StringUtils.join(firstValues, (char)',');
            String second = StringUtils.join(secondValues, (char)',');
            log.warn(String.format("Extra auth verifier values are not equal: (%s) != (%s)", first, second));
        }
        return valid;
    }

    @ConstructorProperties(value={"firstValueProvider", "secondValueProvider", "ignoreCase"})
    public ExtraAuthVerifier(ExtraAuthVerifierValueProvider firstValueProvider, ExtraAuthVerifierValueProvider secondValueProvider, boolean ignoreCase) {
        this.firstValueProvider = firstValueProvider;
        this.secondValueProvider = secondValueProvider;
        this.ignoreCase = ignoreCase;
    }

    public ExtraAuthVerifierValueProvider getFirstValueProvider() {
        return this.firstValueProvider;
    }

    public ExtraAuthVerifierValueProvider getSecondValueProvider() {
        return this.secondValueProvider;
    }
}

