/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.cache.config;

import com.suncode.pwfl.cache.CacheValueLoader;
import com.suncode.pwfl.cache.Weigher;
import java.time.Duration;

public class InMemoryCacheConfig<K, V> {
    private final Long maximumSize;
    private final Duration expireAfterWrite;
    private final CacheValueLoader<? super K, ? extends V> loadFunction;
    private final Duration expireAfterRead;
    private final Long maximumWeight;
    private final Integer concurrencyLevel;
    private final Weigher<? super K, ? super V> weigher;

    private InMemoryCacheConfig(Builder<K, V> builder) {
        this.maximumSize = builder.maximumSize;
        this.expireAfterWrite = builder.expireAfterWrite;
        this.loadFunction = builder.loadFunction;
        this.expireAfterRead = builder.expireAfterRead;
        this.maximumWeight = builder.maximumWeight;
        this.concurrencyLevel = builder.concurrencyLevel;
        this.weigher = builder.weigher;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public Long getMaximumSize() {
        return this.maximumSize;
    }

    public Duration getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public CacheValueLoader<? super K, ? extends V> getLoadFunction() {
        return this.loadFunction;
    }

    public Duration getExpireAfterRead() {
        return this.expireAfterRead;
    }

    public Long getMaximumWeight() {
        return this.maximumWeight;
    }

    public Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public Weigher<? super K, ? super V> getWeigher() {
        return this.weigher;
    }

    public static class Builder<K, V> {
        private Long maximumSize;
        private Duration expireAfterWrite;
        private CacheValueLoader<? super K, ? extends V> loadFunction;
        private Duration expireAfterRead;
        private Long maximumWeight;
        private Integer concurrencyLevel;
        private Weigher<? super K, ? super V> weigher;

        public Builder<K, V> maximumSize(Long maximumSize) {
            this.maximumSize = maximumSize;
            return this;
        }

        public Builder<K, V> expireAfterWrite(Duration expireAfterWrite) {
            this.expireAfterWrite = expireAfterWrite;
            return this;
        }

        public Builder<K, V> loadFunction(CacheValueLoader<? super K, ? extends V> loadFunction) {
            this.loadFunction = loadFunction;
            return this;
        }

        public Builder<K, V> expireAfterRead(Duration expireAfterRead) {
            this.expireAfterRead = expireAfterRead;
            return this;
        }

        public Builder<K, V> maximumWeight(Long maximumWeight) {
            this.maximumWeight = maximumWeight;
            return this;
        }

        public Builder<K, V> concurrencyLevel(Integer concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder<K, V> weigher(Weigher<? super K, ? super V> weigher) {
            this.weigher = weigher;
            return this;
        }

        public InMemoryCacheConfig<K, V> build() {
            return new InMemoryCacheConfig(this);
        }
    }
}

