/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.function;

import com.suncode.pwfl.core.function.Contextual;
import com.suncode.pwfl.core.function.Function;
import com.suncode.pwfl.core.function.FunctionOverride;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.TypedValue;
import com.suncode.pwfl.workflow.component.ContextVariable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.util.Assert;

public class FunctionCall {
    private final FunctionOverride override;
    private final Object[] args;

    public FunctionCall(Function fn, Type<?> returnType, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(returnType, args), "There is no matching function " + String.valueOf(fn) + " override for args: " + String.valueOf(args) + " and return type " + returnType.name()), args);
    }

    public FunctionCall(Function fn, Type<?> returnType, List<Type<?>> parameterTypes, Object ... args) {
        this(FunctionCall.valid(fn.getOverride(returnType, (Type<?>[])parameterTypes.toArray(new Type[parameterTypes.size()])), "There is no matching function " + String.valueOf(fn) + " override for parameter types: " + String.valueOf(parameterTypes) + " and return type " + returnType.name()), args);
    }

    public FunctionCall(FunctionOverride override, Object ... args) {
        Assert.notNull((Object)override, (String)"Function override must not be null");
        this.override = override;
        this.args = args;
    }

    private static FunctionOverride valid(FunctionOverride override, String message) {
        if (override == null) {
            throw new IllegalArgumentException(message);
        }
        return override;
    }

    public String getName() {
        return this.getFunction().getName();
    }

    public Function getFunction() {
        return this.override.getFunction();
    }

    public FunctionOverride getOverride() {
        return this.override;
    }

    public Type<?> getReturnType() {
        return this.override.getReturnType();
    }

    public Object[] getArgs() {
        return (Object[])this.args.clone();
    }

    public <T> T call() {
        return this.override.call(this.args);
    }

    public List<ContextVariable<?>> getContextVariables() {
        return this.flattenArgs().flatMap(arg -> {
            if (arg instanceof Contextual) {
                Contextual contextual = (Contextual)arg;
                return Stream.of(contextual.getContextVariable());
            }
            if (arg instanceof TypedValue) {
                TypedValue wrapped = (TypedValue)arg;
                Object val = wrapped.get();
                if (val instanceof FunctionCall) {
                    FunctionCall fnCall2 = (FunctionCall)val;
                    return fnCall2.getContextVariables().stream();
                }
                if (val instanceof FunctionCall[]) {
                    FunctionCall[] fnCalls = (FunctionCall[])val;
                    return Arrays.stream(fnCalls).flatMap(fnCall -> fnCall.getContextVariables().stream());
                }
            }
            return Stream.empty();
        }).toList();
    }

    private Stream<Object> flattenArgs() {
        return Arrays.stream(this.args).flatMap(arg -> {
            if (arg instanceof Object[]) {
                Object[] objectArray = (Object[])arg;
                return Arrays.stream(objectArray);
            }
            return Stream.of(arg);
        });
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("#").append(this.override.getName()).append("(");
        if (this.args.length > 0) {
            for (Object arg : this.args) {
                sb.append(this.getValueToPrint(arg)).append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.append(")").toString();
    }

    private String getValueToPrint(Object value) {
        if (value instanceof Object[]) {
            return Arrays.toString((Object[])value);
        }
        return String.valueOf(value);
    }
}

