/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.ComboValue;
import com.suncode.pwfl.administration.configuration.ParameterType;
import com.suncode.pwfl.administration.configuration.SystemParameter;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public record SystemParameterDto(ParameterType parameterType, String valueString, Long valueLong, List<String> comboValues, Boolean valueBool, Date valueDate, Double valueDouble) {
    public SystemParameterDto(SystemParameter systemParameter) {
        this(systemParameter.getParameterType(), systemParameter.getValueString(), systemParameter.getValueLong(), Optional.ofNullable(systemParameter.getComboValues()).map(comboValues -> comboValues.stream().map(ComboValue::getValue).toList()).orElse(null), systemParameter.getValueBool(), systemParameter.getValueDate(), systemParameter.getValueDouble());
    }

    @JsonIgnore
    public String getDescryptedValueString() {
        if (this.valueString != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.valueString)) {
                try {
                    return TextCipher.decrypt(this.valueString);
                }
                catch (Exception e) {
                    throw new DecryptingException(e);
                }
            }
            return "";
        }
        return null;
    }
}

