/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.workflow.form.field;

import com.plusmpm.i18n.I18Nxpdl;
import com.suncode.pwfl.workflow.form.AbstractFormField;
import com.suncode.pwfl.workflow.form.FieldType;
import com.suncode.pwfl.workflow.form.datachooser.declaration.DataChooserDeclaration;
import com.suncode.pwfl.workflow.form.datachooser.declaration.MappingDeclaration;
import com.suncode.pwfl.workflow.form.field.DCMapping;
import com.suncode.pwfl.workflow.process.ProcessDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enhydra.shark.xpdl.elements.ExtendedAttributes;

public class DataChooser
extends AbstractFormField {
    private String className;
    private List<String> criteria;
    private List<DCMapping> mappings;
    private Map<String, String> customKeys;

    public DataChooser() {
        this.type = FieldType.DataChooser;
    }

    public DataChooser(String definition, String variableId, ProcessDefinition pd, I18Nxpdl xpdl) {
        String[] lines;
        this.type = FieldType.DataChooser;
        for (String line : lines = definition.split("\n")) {
            String[] prop = line.split("=");
            String key = prop[0];
            String val = "";
            if (prop.length == 2) {
                val = prop[1];
            }
            if (key.equals("class")) {
                this.setClassName(val);
                continue;
            }
            if (key.equals("formCriteria")) {
                this.setCriteria(val);
                continue;
            }
            if (key.startsWith("mapping")) {
                this.addMapping(val, variableId, pd, xpdl);
                continue;
            }
            this.getCustomKeys().put(key, val);
        }
    }

    public DataChooser(DataChooserDeclaration declaration, String variableId, String processId, String activityId, ProcessDefinition pd, I18Nxpdl xpdl) {
        this.type = FieldType.DataChooser;
        this.getCustomKeys().put("componentId", declaration.getId());
        this.getCustomKeys().put("variableId", variableId);
        this.getCustomKeys().put("processId", processId);
        this.getCustomKeys().put("activityId", activityId);
        this.resolveMappings(declaration.getMappings(), variableId, pd, xpdl);
    }

    private void resolveMappings(Map<String, MappingDeclaration> mappings, String variableId, ProcessDefinition pd, I18Nxpdl xpdl) {
        for (String mappingId : mappings.keySet()) {
            this.addMapping(mappingId, mappings.get(mappingId), variableId, pd, xpdl);
        }
    }

    public String toString() {
        return "TextField [getVariableName()=" + this.getVariableName() + ", isRequired()=" + this.isRequired() + ", isReadOnly()=" + this.isReadOnly() + ", getType()=" + String.valueOf((Object)this.getType()) + ", getVariableId()=" + this.getVariableId() + ", getClass()=" + String.valueOf(this.getClass()) + ", hashCode()=" + this.hashCode() + "]";
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<String> getCriteria() {
        if (this.criteria == null) {
            this.criteria = new ArrayList<String>();
        }
        return this.criteria;
    }

    public void setCriteria(List<String> criteria) {
        this.criteria = criteria;
    }

    public void setCriteria(String criteria) {
        this.criteria = Arrays.asList(criteria.split(";"));
    }

    public List<DCMapping> getMappings() {
        if (this.mappings == null) {
            this.mappings = new ArrayList<DCMapping>();
        }
        return this.mappings;
    }

    public void setMappings(List<DCMapping> mappings) {
        this.mappings = mappings;
    }

    private void addMapping(String mappingId, MappingDeclaration mapping, String variableId, ProcessDefinition pd, I18Nxpdl xpdl) {
        this.getMappings().add(new DCMapping(mappingId, mapping, variableId, pd, xpdl));
    }

    private void addMapping(String val, String variableId, ProcessDefinition pd, I18Nxpdl xpdl) {
        this.getMappings().add(new DCMapping(val.split(";", 4), variableId, pd, xpdl));
    }

    public Map<String, String> getCustomKeys() {
        if (this.customKeys == null) {
            this.customKeys = new HashMap<String, String>();
        }
        return this.customKeys;
    }

    public void setCustomKeys(Map<String, String> customKeys) {
        this.customKeys = customKeys;
    }

    @Override
    public void readSpecificAttributes(ExtendedAttributes eas) {
    }
}

