/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.util;

import com.fasterxml.jackson.annotation.JacksonAnnotationsInside;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;

public final class JacksonFormats {
    private JacksonFormats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @JacksonAnnotationsInside
    @JsonSerialize(converter=InstantToIsoConverter.class)
    @JsonDeserialize(converter=InstantFromIsoConverter.class)
    public static @interface InstantAsIso {

        public static class InstantFromIsoConverter
        extends StdConverter<String, Instant> {
            public Instant convert(String value) {
                return Instant.parse(value);
            }
        }

        public static class InstantToIsoConverter
        extends StdConverter<Instant, String> {
            public String convert(Instant value) {
                return value.toString();
            }
        }
    }
}

