/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.google.drive;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;

@Entity
@Table(name="pm_google_drive_refresh_token")
public class GoogleDriveRefreshToken {
    private static final String SEQ = "pm_g_drive_refresh_token_seq";
    @Id
    @Column(nullable=false)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_g_drive_refresh_token_seq")
    @SequenceGenerator(name="pm_g_drive_refresh_token_seq", sequenceName="pm_g_drive_refresh_token_seq")
    private Long id;
    @Column(length=4000, nullable=false)
    private String refreshToken;
    @Column(nullable=false)
    private String googleApiAuthId;

    public static GoogleDriveRefreshTokenBuilder builder() {
        return new GoogleDriveRefreshTokenBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getGoogleApiAuthId() {
        return this.googleApiAuthId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setGoogleApiAuthId(String googleApiAuthId) {
        this.googleApiAuthId = googleApiAuthId;
    }

    public GoogleDriveRefreshToken() {
    }

    @ConstructorProperties(value={"id", "refreshToken", "googleApiAuthId"})
    public GoogleDriveRefreshToken(Long id, String refreshToken, String googleApiAuthId) {
        this.id = id;
        this.refreshToken = refreshToken;
        this.googleApiAuthId = googleApiAuthId;
    }

    public static class GoogleDriveRefreshTokenBuilder {
        private Long id;
        private String refreshToken;
        private String googleApiAuthId;

        GoogleDriveRefreshTokenBuilder() {
        }

        public GoogleDriveRefreshTokenBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public GoogleDriveRefreshTokenBuilder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public GoogleDriveRefreshTokenBuilder googleApiAuthId(String googleApiAuthId) {
            this.googleApiAuthId = googleApiAuthId;
            return this;
        }

        public GoogleDriveRefreshToken build() {
            return new GoogleDriveRefreshToken(this.id, this.refreshToken, this.googleApiAuthId);
        }

        public String toString() {
            return "GoogleDriveRefreshToken.GoogleDriveRefreshTokenBuilder(id=" + this.id + ", refreshToken=" + this.refreshToken + ", googleApiAuthId=" + this.googleApiAuthId + ")";
        }
    }
}

