/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.core.type;

import com.suncode.pwfl.core.type.EvaluableType;
import com.suncode.pwfl.core.type.Type;
import com.suncode.pwfl.core.type.Types;
import org.springframework.util.Assert;

public class TypedValue<T> {
    private final T value;
    private final Type<T> type;

    public TypedValue(T value) {
        this(value, Types.typeOf(value));
    }

    public TypedValue(T value, Type<T> type) {
        Assert.notNull(type, (String)"[Assertion failed] - this argument is required; it must not be null");
        Assert.isTrue((value == null || type.isInstance(value) ? 1 : 0) != 0, (String)"[Assertion failed] - this expression must be true");
        this.value = value;
        this.type = type;
    }

    public static <T> TypedValue<T> nullValue(Type<T> type) {
        return new TypedValue<Object>(null, type);
    }

    public T get() {
        return this.value;
    }

    public final Type<T> getType() {
        return this.type;
    }

    public boolean isInstanceOf(Type<?> target) {
        T value = this.get();
        if (value == null) {
            return true;
        }
        if (this.type.equals(target)) {
            return true;
        }
        return this.getEvaluableType().equals(target);
    }

    public Type<?> getEvaluableType() {
        T value = this.get();
        if (value != null && this.type instanceof EvaluableType) {
            EvaluableType evaluableType = (EvaluableType)this.type;
            return evaluableType.evaluatedType(value);
        }
        return this.type;
    }

    public <V> V getEvaluatedValue() {
        return (V)this.getEvaluatedValue(this.getEvaluableType().javaType());
    }

    public <V> V getEvaluatedValue(Class<V> targetClass) {
        T value = this.get();
        if (value == null) {
            return null;
        }
        if (!this.type.isInstance(targetClass) && this.type instanceof EvaluableType) {
            EvaluableType evaluableType = (EvaluableType)this.type;
            Object evalValue = evaluableType.evaluate(value);
            Type<?> evalType = evaluableType.evaluatedType(value);
            return evalType.readAs(evalValue, targetClass);
        }
        return this.type.readAs(value, targetClass);
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypedValue)) {
            return false;
        }
        TypedValue other = (TypedValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$value = this.value;
        T other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Type<T> this$type = this.getType();
        Type<T> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TypedValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Type<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

