/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.component.support;

import com.google.common.collect.Maps;
import com.suncode.pwfl.component.support.EmptyInstance;
import com.suncode.pwfl.component.support.InvocableMethod;
import com.suncode.pwfl.component.support.ParameterBinder;
import java.util.Map;

public class InstanceBinder
implements ParameterBinder {
    private final Map<Class<?>, Object> map = Maps.newHashMap();
    private final Map<Class<?>, Object> instanceMap = Maps.newHashMap();

    public InstanceBinder(Object ... instances) {
        for (Object instance : instances) {
            if (instance instanceof EmptyInstance) {
                this.map.put(((EmptyInstance)instance).getType(), null);
            }
            this.map.put(instance.getClass(), instance);
        }
    }

    @Override
    public boolean shouldBind(int index, Class<?> type, InvocableMethod method) {
        for (Class<?> clazz : this.map.keySet()) {
            if (!type.isAssignableFrom(clazz)) continue;
            this.instanceMap.put(type, this.map.get(clazz));
            return true;
        }
        return false;
    }

    @Override
    public Object bind(int index, Class<?> type, InvocableMethod method) {
        return this.instanceMap.get(type);
    }
}

