/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.audit.builder;

import com.suncode.pwfl.audit.AuditWrapper;
import com.suncode.pwfl.audit.util.AuditTypes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class ManualAuditBuilder {
    public static String UNKNOWN = "UNKNOWN";
    private String username = UNKNOWN;
    private String ipAddress = UNKNOWN;
    private String params = "";
    private String type = "";
    private boolean success = false;
    private Date stopped;
    private Date started;

    public static ManualAuditBuilder getInstance() {
        return new ManualAuditBuilder();
    }

    public ManualAuditBuilder username(String username) {
        if (StringUtils.isNotBlank((CharSequence)username)) {
            this.username = username;
        }
        return this;
    }

    public ManualAuditBuilder ipAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public ManualAuditBuilder type(AuditTypes type) {
        return this.type(type.toString());
    }

    public ManualAuditBuilder type(String type) {
        this.type = type;
        return this;
    }

    public ManualAuditBuilder started(Date started) {
        this.started = started;
        return this;
    }

    public ManualAuditBuilder stopped(Date stopped) {
        this.stopped = stopped;
        return this;
    }

    public ManualAuditBuilder params(Map<String, Object> params) {
        String stringParams = params.entrySet().stream().map(entry -> {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String stringValue = "null";
            if (value != null) {
                if (value instanceof List) {
                    stringValue = ((List)value).stream().map(Object::toString).collect(Collectors.joining(", "));
                } else if (value instanceof Date) {
                    Date date = (Date)value;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    stringValue = format.format(date);
                } else {
                    stringValue = value.toString();
                }
            }
            return key + "=" + stringValue;
        }).collect(Collectors.joining("@AUDIT_PARAM@"));
        return this.params(stringParams);
    }

    public ManualAuditBuilder params(String params) {
        this.params = params;
        return this;
    }

    public ManualAuditBuilder success(boolean success) {
        this.success = success;
        return this;
    }

    public AuditWrapper build() {
        long duration;
        Assert.notNull((Object)this.type, (String)"Audit type cannot be null");
        if (this.started == null) {
            this.started = new Date();
        }
        if (this.stopped == null) {
            this.stopped = new Date();
        }
        Assert.isTrue(((duration = this.stopped.getTime() - this.started.getTime()) >= 0L ? 1 : 0) != 0, (String)"Audit duration must be more than 0 ms");
        return AuditWrapper.builder().userId(this.username).ipAddress(this.ipAddress).threadId(Thread.currentThread().getName()).auditType(this.type).auditSuccess(this.success).auditParams(this.params).auditStarted(this.started.getTime()).auditStopped(this.stopped.getTime()).auditDuration(duration).auditCategory("").build();
    }

    private ManualAuditBuilder() {
    }
}

