/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.substitution;

import com.suncode.pwfl.administration.structure.Role;
import com.suncode.pwfl.administration.user.User;
import java.beans.ConstructorProperties;
import java.util.Objects;
import org.joda.time.LocalDateTime;

public class Substitution {
    public static final String JOIN_ROLE = "role";
    public static final String JOIN_SUBSTITUTED = "substituted";
    public static final String JOIN_SUBSTITUTE = "substitute";
    private Long id;
    private String processDefId;
    private Role role;
    private User substituted;
    private User substitute;
    private Long lStartDate;
    private Long lFinishDate;

    public LocalDateTime getStartDate() {
        if (this.lStartDate != null) {
            return new LocalDateTime((Object)this.lStartDate);
        }
        return null;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.lStartDate = startDate != null ? Long.valueOf(startDate.toDateTime().getMillis()) : null;
    }

    private Long getlStartDate() {
        return this.lStartDate;
    }

    private void setlStartDate(Long lStartDate) {
        this.lStartDate = lStartDate;
    }

    public LocalDateTime getFinishDate() {
        if (this.lFinishDate != null) {
            return new LocalDateTime((Object)this.lFinishDate);
        }
        return null;
    }

    public void setFinishDate(LocalDateTime finishDate) {
        this.setFinishDate(finishDate, true);
    }

    public void setFinishDate(LocalDateTime finishDate, boolean endOfDay) {
        if (finishDate != null) {
            if (endOfDay) {
                finishDate = finishDate.withTime(23, 59, 59, 999);
            }
            this.lFinishDate = finishDate.toDateTime().getMillis();
        } else {
            this.lFinishDate = null;
        }
    }

    private Long getlFinishDate() {
        return this.lFinishDate;
    }

    private void setlFinishDate(Long lFinishDate) {
        this.lFinishDate = lFinishDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Substitution that = (Substitution)o;
        return Objects.equals(this.processDefId, that.processDefId) && Objects.equals(this.role, that.role) && Objects.equals(this.substituted, that.substituted) && Objects.equals(this.substitute, that.substitute) && Objects.equals(this.lStartDate, that.lStartDate) && Objects.equals(this.lFinishDate, that.lFinishDate);
    }

    public int hashCode() {
        return Objects.hash(this.processDefId, this.role, this.substituted, this.substitute, this.lStartDate, this.lFinishDate);
    }

    public static SubstitutionBuilder builder() {
        return new SubstitutionBuilder();
    }

    @ConstructorProperties(value={"id", "processDefId", "role", "substituted", "substitute", "lStartDate", "lFinishDate"})
    public Substitution(Long id, String processDefId, Role role, User substituted, User substitute, Long lStartDate, Long lFinishDate) {
        this.id = id;
        this.processDefId = processDefId;
        this.role = role;
        this.substituted = substituted;
        this.substitute = substitute;
        this.lStartDate = lStartDate;
        this.lFinishDate = lFinishDate;
    }

    public Substitution() {
    }

    public Long getId() {
        return this.id;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public Role getRole() {
        return this.role;
    }

    public User getSubstituted() {
        return this.substituted;
    }

    public User getSubstitute() {
        return this.substitute;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setSubstituted(User substituted) {
        this.substituted = substituted;
    }

    public void setSubstitute(User substitute) {
        this.substitute = substitute;
    }

    public static class SubstitutionBuilder {
        private Long id;
        private String processDefId;
        private Role role;
        private User substituted;
        private User substitute;
        private Long lStartDate;
        private Long lFinishDate;

        SubstitutionBuilder() {
        }

        public SubstitutionBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public SubstitutionBuilder processDefId(String processDefId) {
            this.processDefId = processDefId;
            return this;
        }

        public SubstitutionBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public SubstitutionBuilder substituted(User substituted) {
            this.substituted = substituted;
            return this;
        }

        public SubstitutionBuilder substitute(User substitute) {
            this.substitute = substitute;
            return this;
        }

        public SubstitutionBuilder lStartDate(Long lStartDate) {
            this.lStartDate = lStartDate;
            return this;
        }

        public SubstitutionBuilder lFinishDate(Long lFinishDate) {
            this.lFinishDate = lFinishDate;
            return this;
        }

        public Substitution build() {
            return new Substitution(this.id, this.processDefId, this.role, this.substituted, this.substitute, this.lStartDate, this.lFinishDate);
        }

        public String toString() {
            return "Substitution.SubstitutionBuilder(id=" + this.id + ", processDefId=" + this.processDefId + ", role=" + String.valueOf(this.role) + ", substituted=" + String.valueOf(this.substituted) + ", substitute=" + String.valueOf(this.substitute) + ", lStartDate=" + this.lStartDate + ", lFinishDate=" + this.lFinishDate + ")";
        }
    }
}

