/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.pwfl.administration.email.oauth.client;

import com.plusmpm.security.TextCipher;
import com.suncode.pwfl.administration.configuration.exception.DecryptingException;
import com.suncode.pwfl.administration.configuration.exception.EncryptingException;
import com.suncode.pwfl.administration.email.oauth.client.OAuth2AuthenticationMethod;
import com.suncode.pwfl.administration.email.oauth.connection.OAuth2Connection;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="pm_oauth_client")
@SequenceGenerator(name="pm_oauth_client_id_seq", sequenceName="pm_oauth_client_id_seq")
public class OAuth2Client {
    public static final String JOIN_CONNECTIONS = "connections";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="pm_oauth_client_id_seq")
    private Long id;
    private String name;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private OAuth2AuthenticationMethod authenticationMethod;
    @Column(length=512)
    private String clientId;
    @Column(length=512)
    private String clientSecret;
    @Column(length=512)
    private String scope;
    @Column(length=512)
    private String authorizationUrl;
    @Column(length=512)
    private String tokenUrl;
    @Column(length=512)
    private String redirectUrl;
    @Column(name="pkce", nullable=false)
    private boolean pkce;
    @Column(name="allowed_groups", length=2000)
    private String allowedGroups;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="clientid")
    private List<OAuth2Connection> connections;

    public String getDecryptedClientSecret() {
        if (StringUtils.isNotEmpty((CharSequence)this.clientSecret)) {
            try {
                return TextCipher.decrypt(this.clientSecret);
            }
            catch (Exception e) {
                throw new DecryptingException();
            }
        }
        return this.clientSecret;
    }

    public void setEncryptedClientSecret(String clientSecret) {
        if (StringUtils.isNotEmpty((CharSequence)clientSecret)) {
            try {
                this.clientSecret = TextCipher.encrypt(clientSecret);
            }
            catch (Exception e) {
                throw new EncryptingException();
            }
        } else {
            this.clientSecret = clientSecret;
        }
    }

    public List<String> getAllowedGroupsList() {
        if (StringUtils.isBlank((CharSequence)this.allowedGroups)) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.allowedGroups.split(",")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public void setAllowedGroupsList(List<String> groups) {
        this.allowedGroups = groups == null || groups.isEmpty() ? null : groups.stream().filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.joining(","));
    }

    public static OAuth2ClientBuilder builder() {
        return new OAuth2ClientBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public OAuth2AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public String getAuthorizationUrl() {
        return this.authorizationUrl;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public boolean isPkce() {
        return this.pkce;
    }

    public String getAllowedGroups() {
        return this.allowedGroups;
    }

    public List<OAuth2Connection> getConnections() {
        return this.connections;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthenticationMethod(OAuth2AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.authorizationUrl = authorizationUrl;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public void setPkce(boolean pkce) {
        this.pkce = pkce;
    }

    public void setAllowedGroups(String allowedGroups) {
        this.allowedGroups = allowedGroups;
    }

    public void setConnections(List<OAuth2Connection> connections) {
        this.connections = connections;
    }

    public OAuth2Client() {
    }

    @ConstructorProperties(value={"id", "name", "authenticationMethod", "clientId", "clientSecret", "scope", "authorizationUrl", "tokenUrl", "redirectUrl", "pkce", "allowedGroups", "connections"})
    public OAuth2Client(Long id, String name, OAuth2AuthenticationMethod authenticationMethod, String clientId, String clientSecret, String scope, String authorizationUrl, String tokenUrl, String redirectUrl, boolean pkce, String allowedGroups, List<OAuth2Connection> connections) {
        this.id = id;
        this.name = name;
        this.authenticationMethod = authenticationMethod;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.authorizationUrl = authorizationUrl;
        this.tokenUrl = tokenUrl;
        this.redirectUrl = redirectUrl;
        this.pkce = pkce;
        this.allowedGroups = allowedGroups;
        this.connections = connections;
    }

    public static class OAuth2ClientBuilder {
        private Long id;
        private String name;
        private OAuth2AuthenticationMethod authenticationMethod;
        private String clientId;
        private String clientSecret;
        private String scope;
        private String authorizationUrl;
        private String tokenUrl;
        private String redirectUrl;
        private boolean pkce;
        private String allowedGroups;
        private List<OAuth2Connection> connections;

        public OAuth2ClientBuilder encryptedClientSecret(String clientSecret) {
            if (StringUtils.isNotEmpty((CharSequence)clientSecret)) {
                try {
                    this.clientSecret = TextCipher.encrypt(clientSecret);
                }
                catch (Exception e) {
                    throw new EncryptingException();
                }
            } else {
                this.clientSecret = clientSecret;
            }
            return this;
        }

        OAuth2ClientBuilder() {
        }

        public OAuth2ClientBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public OAuth2ClientBuilder name(String name) {
            this.name = name;
            return this;
        }

        public OAuth2ClientBuilder authenticationMethod(OAuth2AuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        public OAuth2ClientBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public OAuth2ClientBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public OAuth2ClientBuilder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public OAuth2ClientBuilder authorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
            return this;
        }

        public OAuth2ClientBuilder tokenUrl(String tokenUrl) {
            this.tokenUrl = tokenUrl;
            return this;
        }

        public OAuth2ClientBuilder redirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public OAuth2ClientBuilder pkce(boolean pkce) {
            this.pkce = pkce;
            return this;
        }

        public OAuth2ClientBuilder allowedGroups(String allowedGroups) {
            this.allowedGroups = allowedGroups;
            return this;
        }

        public OAuth2ClientBuilder connections(List<OAuth2Connection> connections) {
            this.connections = connections;
            return this;
        }

        public OAuth2Client build() {
            return new OAuth2Client(this.id, this.name, this.authenticationMethod, this.clientId, this.clientSecret, this.scope, this.authorizationUrl, this.tokenUrl, this.redirectUrl, this.pkce, this.allowedGroups, this.connections);
        }

        public String toString() {
            return "OAuth2Client.OAuth2ClientBuilder(id=" + this.id + ", name=" + this.name + ", authenticationMethod=" + String.valueOf((Object)this.authenticationMethod) + ", clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", scope=" + this.scope + ", authorizationUrl=" + this.authorizationUrl + ", tokenUrl=" + this.tokenUrl + ", redirectUrl=" + this.redirectUrl + ", pkce=" + this.pkce + ", allowedGroups=" + this.allowedGroups + ", connections=" + String.valueOf(this.connections) + ")";
        }
    }
}

